/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.injection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.injection.IFieldValueFactory;

public class CompoundFieldValueFactory
implements IFieldValueFactory {
    private List delegates = new ArrayList();

    public CompoundFieldValueFactory(IFieldValueFactory[] factories) {
        if (factories == null) {
            throw new IllegalArgumentException("argument [factories] cannot be null");
        }
        for (int i = 0; i < factories.length; ++i) {
            this.delegates.add(factories[i]);
        }
    }

    public CompoundFieldValueFactory(List factories) {
        if (factories == null) {
            throw new IllegalArgumentException("argument [factories] cannot be null");
        }
        this.delegates.addAll(factories);
    }

    public CompoundFieldValueFactory(IFieldValueFactory f1, IFieldValueFactory f2) {
        if (f1 == null) {
            throw new IllegalArgumentException("argument [f1] cannot be null");
        }
        if (f2 == null) {
            throw new IllegalArgumentException("argument [f2] cannot be null");
        }
        this.delegates.add(f1);
        this.delegates.add(f2);
    }

    public void addFactory(IFieldValueFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("argument [factory] cannot be null");
        }
        this.delegates.add(factory);
    }

    public Object getFieldValue(Field field, Object fieldOwner) {
        Iterator it = this.delegates.iterator();
        while (it.hasNext()) {
            IFieldValueFactory factory = (IFieldValueFactory)it.next();
            Object object = factory.getFieldValue(field, fieldOwner);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public boolean supportsField(Field field) {
        Iterator it = this.delegates.iterator();
        while (it.hasNext()) {
            IFieldValueFactory factory = (IFieldValueFactory)it.next();
            if (!factory.supportsField(field)) continue;
            return true;
        }
        return false;
    }
}

