/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.proxy;

import java.lang.reflect.Proxy;
import junit.framework.TestCase;
import org.apache.wicket.proxy.ILazyInitProxy;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;
import org.apache.wicket.proxy.util.ConcreteObject;
import org.apache.wicket.proxy.util.IInterface;
import org.apache.wicket.proxy.util.IObjectMethodTester;
import org.apache.wicket.proxy.util.InterfaceObject;
import org.apache.wicket.proxy.util.ObjectMethodTester;
import org.apache.wicket.util.lang.Objects;

public class LazyInitProxyFactoryTest
extends TestCase {
    private static InterfaceObject interfaceObject = new InterfaceObject("interface");
    private static ConcreteObject concreteObject = new ConcreteObject("concrete");
    private static IProxyTargetLocator interfaceObjectLocator = new IProxyTargetLocator(){
        private static final long serialVersionUID = 1L;

        public Object locateProxyTarget() {
            return interfaceObject;
        }
    };
    private static IProxyTargetLocator concreteObjectLocator = new IProxyTargetLocator(){
        private static final long serialVersionUID = 1L;

        public Object locateProxyTarget() {
            return concreteObject;
        }
    };
    private static IProxyTargetLocator stringObjectLocator = new IProxyTargetLocator(){
        private static final long serialVersionUID = 1L;

        public Object locateProxyTarget() {
            return "StringLiteral";
        }
    };

    public void testInterfaceProxy() {
        IInterface proxy = (IInterface)LazyInitProxyFactory.createProxy((Class)IInterface.class, (IProxyTargetLocator)interfaceObjectLocator);
        LazyInitProxyFactoryTest.assertTrue((boolean)Proxy.isProxyClass(proxy.getClass()));
        LazyInitProxyFactoryTest.assertTrue((boolean)(proxy instanceof ILazyInitProxy));
        LazyInitProxyFactoryTest.assertTrue((((ILazyInitProxy)proxy).getObjectLocator() == interfaceObjectLocator ? 1 : 0) != 0);
        LazyInitProxyFactoryTest.assertEquals((String)proxy.getMessage(), (String)"interface");
        IInterface proxy2 = (IInterface)Objects.cloneObject((Object)proxy);
        LazyInitProxyFactoryTest.assertTrue((proxy != proxy2 ? 1 : 0) != 0);
        LazyInitProxyFactoryTest.assertEquals((String)proxy2.getMessage(), (String)"interface");
        final ObjectMethodTester tester = new ObjectMethodTester();
        LazyInitProxyFactoryTest.assertTrue((boolean)tester.isValid());
        IProxyTargetLocator testerLocator = new IProxyTargetLocator(){
            private static final long serialVersionUID = 1L;

            public Object locateProxyTarget() {
                return tester;
            }
        };
        IObjectMethodTester testerProxy = (IObjectMethodTester)LazyInitProxyFactory.createProxy((Class)IObjectMethodTester.class, (IProxyTargetLocator)testerLocator);
        ((Object)testerProxy).equals((Object)this);
        ((Object)testerProxy).hashCode();
        ((Object)testerProxy).toString();
        LazyInitProxyFactoryTest.assertTrue((boolean)tester.isValid());
    }

    public void testConcreteProxy() {
        ConcreteObject proxy = (ConcreteObject)LazyInitProxyFactory.createProxy((Class)ConcreteObject.class, (IProxyTargetLocator)concreteObjectLocator);
        LazyInitProxyFactoryTest.assertTrue((boolean)(proxy instanceof ILazyInitProxy));
        LazyInitProxyFactoryTest.assertTrue((((ILazyInitProxy)proxy).getObjectLocator() == concreteObjectLocator ? 1 : 0) != 0);
        LazyInitProxyFactoryTest.assertFalse((boolean)Proxy.isProxyClass(proxy.getClass()));
        LazyInitProxyFactoryTest.assertEquals((String)proxy.getMessage(), (String)"concrete");
        ConcreteObject proxy2 = (ConcreteObject)Objects.cloneObject((Object)proxy);
        LazyInitProxyFactoryTest.assertTrue((proxy != proxy2 ? 1 : 0) != 0);
        LazyInitProxyFactoryTest.assertEquals((String)proxy2.getMessage(), (String)"concrete");
        final ObjectMethodTester tester = new ObjectMethodTester();
        LazyInitProxyFactoryTest.assertTrue((boolean)tester.isValid());
        IProxyTargetLocator testerLocator = new IProxyTargetLocator(){
            private static final long serialVersionUID = 1L;

            public Object locateProxyTarget() {
                return tester;
            }
        };
        ObjectMethodTester testerProxy = (ObjectMethodTester)LazyInitProxyFactory.createProxy((Class)ObjectMethodTester.class, (IProxyTargetLocator)testerLocator);
        testerProxy.equals((Object)this);
        testerProxy.hashCode();
        testerProxy.toString();
        LazyInitProxyFactoryTest.assertTrue((boolean)tester.isValid());
    }

    public void testCGLibInterceptorReplacement() {
        LazyInitProxyFactory.ProxyReplacement ser = new LazyInitProxyFactory.ProxyReplacement(ConcreteObject.class.getName(), concreteObjectLocator);
        ConcreteObject proxy2 = (ConcreteObject)Objects.cloneObject((Object)ser);
        LazyInitProxyFactoryTest.assertEquals((String)proxy2.getMessage(), (String)"concrete");
    }

    public void testStringProxy() {
        String proxy = (String)LazyInitProxyFactory.createProxy((Class)String.class, (IProxyTargetLocator)stringObjectLocator);
        LazyInitProxyFactoryTest.assertEquals((String)"StringLiteral", (String)proxy);
    }
}

