/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.injection;

import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.injection.util.MockDependency;
import org.apache.wicket.injection.util.TestObject;

public class InjectorTest
extends TestCase {
    private static MockDependency dependency = new MockDependency("inject");
    private static IFieldValueFactory factory = new IFieldValueFactory(){

        public Object getFieldValue(Field field, Object fieldOwner) {
            return dependency;
        }

        public boolean supportsField(Field field) {
            return true;
        }
    };
    static /* synthetic */ Class class$org$apache$wicket$injection$util$InternalTestObject;

    public void testInjection() {
        TestObject testObject = new TestObject();
        Injector.getInstance().inject((Object)testObject, factory);
        InjectorTest.assertEquals((String)testObject.getDependency1().getMessage(), (String)"inject");
        InjectorTest.assertEquals((String)testObject.getDependency2().getMessage(), (String)"dont-inject");
        InjectorTest.assertEquals((String)testObject.getDependency3().getMessage(), (String)"dont-inject");
        InjectorTest.assertEquals((String)testObject.getDependency4().getMessage(), (String)"inject");
    }

    public void testBreakOnBoundary() {
        Injector injector = new Injector(){

            protected boolean isBoundaryClass(Class clazz) {
                return clazz.equals(class$org$apache$wicket$injection$util$InternalTestObject == null ? (class$org$apache$wicket$injection$util$InternalTestObject = InjectorTest.class$("org.apache.wicket.injection.util.InternalTestObject")) : class$org$apache$wicket$injection$util$InternalTestObject);
            }
        };
        TestObject testObject = new TestObject();
        injector.inject((Object)testObject, factory);
        InjectorTest.assertTrue((testObject.getDependency1() == null ? 1 : 0) != 0);
        InjectorTest.assertEquals((String)testObject.getDependency2().getMessage(), (String)"dont-inject");
        InjectorTest.assertEquals((String)testObject.getDependency3().getMessage(), (String)"dont-inject");
        InjectorTest.assertEquals((String)testObject.getDependency4().getMessage(), (String)"inject");
    }
}

