/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.injection;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.wicket.injection.CompoundFieldValueFactory;
import org.apache.wicket.injection.IFieldValueFactory;
import org.easymock.MockControl;

public class CompoundFieldValueFactoryTest
extends TestCase {
    private Integer testField;
    private Field field;
    private MockControl[] ctrl = new MockControl[4];
    private IFieldValueFactory[] fact = new IFieldValueFactory[4];
    static /* synthetic */ Class class$org$apache$wicket$injection$IFieldValueFactory;

    protected void setUp() throws Exception {
        Field field = CompoundFieldValueFactoryTest.class.getDeclaredField("testField");
        for (int i = 0; i < 4; ++i) {
            this.ctrl[i] = MockControl.createControl((Class)(class$org$apache$wicket$injection$IFieldValueFactory == null ? CompoundFieldValueFactoryTest.class$("org.apache.wicket.injection.IFieldValueFactory") : class$org$apache$wicket$injection$IFieldValueFactory));
            this.fact[i] = (IFieldValueFactory)this.ctrl[i].getMock();
        }
    }

    protected void prepare(int cnt) {
        for (int i = 0; i < cnt; ++i) {
            this.ctrl[i].expectAndReturn(this.fact[i].getFieldValue(this.field, (Object)this), null);
            this.ctrl[i].replay();
        }
    }

    protected void verify(int cnt) {
        for (int i = 0; i < cnt; ++i) {
            this.ctrl[i].verify();
        }
    }

    public void testArrayConstructor() {
        this.prepare(2);
        CompoundFieldValueFactory f = new CompoundFieldValueFactory(new IFieldValueFactory[]{this.fact[0], this.fact[1]});
        f.getFieldValue(this.field, (Object)this);
        this.verify(2);
        try {
            f = new CompoundFieldValueFactory((IFieldValueFactory[])null);
            CompoundFieldValueFactoryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testListConstructor() {
        this.prepare(4);
        List<IFieldValueFactory> list = Arrays.asList(this.fact[0], this.fact[1], this.fact[2], this.fact[3]);
        CompoundFieldValueFactory f = new CompoundFieldValueFactory(list);
        f.getFieldValue(this.field, (Object)this);
        this.verify(4);
        try {
            f = new CompoundFieldValueFactory((List)null);
            CompoundFieldValueFactoryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testABConstructor() {
        this.prepare(2);
        CompoundFieldValueFactory f = new CompoundFieldValueFactory(this.fact[0], this.fact[1]);
        f.getFieldValue(this.field, (Object)this);
        this.verify(2);
        try {
            f = new CompoundFieldValueFactory(this.fact[0], null);
            CompoundFieldValueFactoryTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            f = new CompoundFieldValueFactory(null, this.fact[1]);
            CompoundFieldValueFactoryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBreakOnNonNullReturn() {
        this.prepare(2);
        this.ctrl[2].expectAndReturn(this.fact[2].getFieldValue(this.field, (Object)this), new Object());
        this.ctrl[2].replay();
        this.ctrl[3].replay();
        List<IFieldValueFactory> list = Arrays.asList(this.fact[0], this.fact[1], this.fact[2], this.fact[3]);
        CompoundFieldValueFactory f = new CompoundFieldValueFactory(list);
        f.getFieldValue(this.field, (Object)this);
        this.verify(4);
    }

    public void testAdd() {
        this.prepare(3);
        CompoundFieldValueFactory f = new CompoundFieldValueFactory(new IFieldValueFactory[]{this.fact[0], this.fact[1]});
        f.addFactory(this.fact[2]);
        f.getFieldValue(this.field, (Object)this);
        this.verify(3);
        try {
            f.addFactory(null);
            CompoundFieldValueFactoryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

