/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree;

import java.util.Optional;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.Node;
import org.apache.wicket.extensions.markup.html.repeater.tree.nested.BranchItem;
import org.apache.wicket.extensions.markup.html.repeater.tree.nested.Subtree;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public abstract class NestedTree<T>
extends AbstractTree<T> {
    private static final long serialVersionUID = 1L;

    public NestedTree(String id, ITreeProvider<T> provider) {
        this(id, provider, null);
    }

    public NestedTree(String id, ITreeProvider<T> provider, IModel<? extends Set<T>> state) {
        super(id, provider, state);
        this.add(new Component[]{this.newSubtree("subtree", new RootsModel())});
    }

    public Component newSubtree(String id, IModel<T> model) {
        return new Subtree<T>(id, this, model);
    }

    @Override
    public Component newNodeComponent(String id, IModel<T> model) {
        Component node = super.newNodeComponent(id, model);
        node.setOutputMarkupId(true);
        return node;
    }

    @Override
    public void updateBranch(T t, Optional<? extends IPartialPageRequestHandler> handler) {
        handler.ifPresent(target -> {
            IModel<Object> model = this.getProvider().model(t);
            this.visitChildren(BranchItem.class, new IVisitor<BranchItem<T>, Void>((IModel)model, (IPartialPageRequestHandler)target){
                final /* synthetic */ IModel val$model;
                final /* synthetic */ IPartialPageRequestHandler val$target;
                {
                    this.val$model = iModel;
                    this.val$target = iPartialPageRequestHandler;
                }

                public void component(BranchItem<T> branch, IVisit<Void> visit) {
                    if (this.val$model.equals(branch.getModel())) {
                        this.val$target.add(new Component[]{branch});
                        visit.stop();
                    }
                }
            });
            model.detach();
        });
    }

    @Override
    public void updateNode(T node, Optional<? extends IPartialPageRequestHandler> targetOptional) {
        targetOptional.ifPresent(target -> {
            IModel<Object> model = this.getProvider().model(node);
            this.visitChildren(Node.class, new IVisitor<Node<T>, Void>((IModel)model, (IPartialPageRequestHandler)target){
                final /* synthetic */ IModel val$model;
                final /* synthetic */ IPartialPageRequestHandler val$target;
                {
                    this.val$model = iModel;
                    this.val$target = iPartialPageRequestHandler;
                }

                public void component(Node<T> node, IVisit<Void> visit) {
                    if (this.val$model.equals(node.getModel())) {
                        this.val$target.add(new Component[]{node});
                        visit.stop();
                    }
                    visit.dontGoDeeper();
                }
            });
            model.detach();
        });
    }

    private class RootsModel
    implements IModel<T> {
        private static final long serialVersionUID = 1L;

        private RootsModel() {
        }

        public T getObject() {
            return null;
        }
    }
}

