/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IDataExporter;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.AbstractResourceStreamWriter;
import org.apache.wicket.util.resource.IResourceStream;

public class ExportToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;
    private static final IModel<String> DEFAULT_MESSAGE_MODEL = new ResourceModel("datatable.export-to");
    private static final IModel<String> DEFAULT_FILE_NAME_MODEL = new ResourceModel("datatable.export-file-name");
    private final List<IDataExporter> dataExporters = new LinkedList<IDataExporter>();
    private IModel<String> messageModel;
    private IModel<String> fileNameModel;

    public ExportToolbar(DataTable<?, ?> table) {
        this(table, DEFAULT_MESSAGE_MODEL, DEFAULT_FILE_NAME_MODEL);
    }

    public ExportToolbar(DataTable<?, ?> table, IModel<String> fileNameModel) {
        this(table, DEFAULT_MESSAGE_MODEL, fileNameModel);
    }

    public ExportToolbar(DataTable<?, ?> table, IModel<String> messageModel, IModel<String> fileNameModel) {
        super(table);
        this.messageModel = messageModel;
        this.fileNameModel = fileNameModel;
    }

    public ExportToolbar setMessageModel(IModel<String> messageModel) {
        this.messageModel = (IModel)Args.notNull(messageModel, (String)"messageModel");
        return this;
    }

    public ExportToolbar setFileNameModel(IModel<String> fileNameModel) {
        this.fileNameModel = (IModel)Args.notNull(fileNameModel, (String)"fileNameModel");
        return this;
    }

    public IModel<String> getFileNameModel() {
        return this.fileNameModel;
    }

    public IModel<String> getMessageModel() {
        return this.messageModel;
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer td = new WebMarkupContainer("td");
        this.add(new Component[]{td});
        td.add(new Behavior[]{AttributeModifier.replace((String)"colspan", (IModel)new IModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return String.valueOf(ExportToolbar.this.getTable().getColumns().size()).intern();
            }
        })});
        td.add(new Component[]{new Label("exportTo", this.messageModel)});
        RepeatingView linkContainers = new RepeatingView("linkContainer");
        td.add(new Component[]{linkContainers});
        for (IDataExporter exporter : this.dataExporters) {
            WebMarkupContainer span = new WebMarkupContainer(linkContainers.newChildId());
            linkContainers.add(new Component[]{span});
            span.add(new Component[]{this.createExportLink("exportLink", exporter)});
        }
    }

    protected Component createExportLink(String componentId, final IDataExporter dataExporter) {
        ResourceStreamResource resource = new ResourceStreamResource(){

            protected IResourceStream getResourceStream(IResource.Attributes attributes) {
                return new DataExportResourceStreamWriter(dataExporter, ExportToolbar.this.getTable());
            }
        }.setFileName((String)this.fileNameModel.getObject() + "." + dataExporter.getFileNameExtension());
        return new ResourceLink(componentId, (IResource)resource).setBody(dataExporter.getDataFormatNameModel());
    }

    public boolean isVisible() {
        if (this.dataExporters.isEmpty()) {
            return false;
        }
        if (this.getTable().getRowCount() == 0L) {
            return false;
        }
        for (IColumn<?, ?> col : this.getTable().getColumns()) {
            if (!(col instanceof IExportableColumn)) continue;
            return true;
        }
        return false;
    }

    protected void onDetach() {
        this.fileNameModel.detach();
        this.messageModel.detach();
        super.onDetach();
    }

    public ExportToolbar addDataExporter(IDataExporter exporter) {
        Args.notNull((Object)exporter, (String)"exporter");
        this.dataExporters.add(exporter);
        return this;
    }

    public static class DataExportResourceStreamWriter
    extends AbstractResourceStreamWriter {
        private final IDataExporter dataExporter;
        private final DataTable<?, ?> dataTable;

        public DataExportResourceStreamWriter(IDataExporter dataExporter, DataTable<?, ?> dataTable) {
            this.dataExporter = dataExporter;
            this.dataTable = dataTable;
        }

        public void write(OutputStream output) throws IOException {
            this.exportData(this.dataTable, this.dataExporter, output);
        }

        public String getContentType() {
            return this.dataExporter.getContentType();
        }

        private <T, S> void exportData(DataTable<T, S> dataTable, IDataExporter dataExporter, OutputStream outputStream) throws IOException {
            IDataProvider<T> dataProvider = dataTable.getDataProvider();
            LinkedList exportableColumns = new LinkedList();
            for (IColumn<T, S> col : dataTable.getColumns()) {
                if (!(col instanceof IExportableColumn)) continue;
                exportableColumns.add((IExportableColumn)col);
            }
            dataExporter.exportData(dataProvider, exportableColumns, outputStream);
        }
    }
}

