/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.lambda.WicketFunction;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class LambdaColumn<T, S>
extends AbstractColumn<T, S>
implements IExportableColumn<T, S> {
    private static final long serialVersionUID = 1L;
    private final WicketFunction<T, ?> function;

    public LambdaColumn(IModel<String> displayModel, WicketFunction<T, ?> function) {
        this(displayModel, null, function);
    }

    public LambdaColumn(IModel<String> displayModel, S sortProperty, WicketFunction<T, ?> function) {
        super(displayModel, sortProperty);
        this.function = (WicketFunction)Args.notNull(function, (String)"function");
    }

    @Override
    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        item.add(new Component[]{new Label(componentId, this.getDataModel(rowModel))});
    }

    @Override
    public IModel<?> getDataModel(final IModel<T> rowModel) {
        IModel<Object> dataModel = new IModel<Object>(){

            public Object getObject() {
                Object before = rowModel.getObject();
                if (before == null) {
                    return null;
                }
                return LambdaColumn.this.function.apply(before);
            }

            public void detach() {
                rowModel.detach();
            }
        };
        return dataModel;
    }
}

