/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.commons.fileupload2.FileItem;
import org.apache.wicket.commons.fileupload2.FileUploadException;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public class AjaxFileDropBehavior
extends AjaxEventBehavior {
    public static final String DRAG_OVER_CLASS_KEY = CssUtils.key(AjaxFileDropBehavior.class, (String)"dragover");
    private static final ResourceReference JS = new PackageResourceReference(AjaxFileDropBehavior.class, "wicket-ajaxupload.js");
    private Bytes maxSize;
    private Bytes fileMaxSize;
    private long fileCountMax = -1L;
    private String parameterName = "f";

    public AjaxFileDropBehavior() {
        super("dragenter dragover dragleave drop");
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS));
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.setMultipart(true);
        attributes.setMethod(AjaxRequestAttributes.Method.POST);
        attributes.setPreventDefault(true);
        attributes.getAjaxCallListeners().add(new AjaxCallListener(){

            public CharSequence getPrecondition(Component component) {
                String css = AjaxFileDropBehavior.this.getComponent().getString(DRAG_OVER_CLASS_KEY);
                return String.format("jQuery('#' + attrs.c).toggleClass('%s', attrs.event.type === 'dragover'); return (attrs.event.type === 'drop');", css);
            }
        });
        attributes.getDynamicExtraParameters().add(String.format("return Wicket.DataTransfer.getFilesAsParamArray(attrs.event.originalEvent, '%s');", this.parameterName));
    }

    protected void onEvent(AjaxRequestTarget target) {
        try {
            ServletWebRequest request = (ServletWebRequest)this.getComponent().getRequest();
            MultipartServletWebRequest multipartWebRequest = request.newMultipartWebRequest(this.getMaxSize(), this.getComponent().getPage().getId());
            multipartWebRequest.setFileMaxSize(this.getFileMaxSize());
            multipartWebRequest.setFileCountMax(this.getFileCountMax());
            multipartWebRequest.parseFileParts();
            this.getComponent().getRequestCycle().setRequest((Request)multipartWebRequest);
            ArrayList<FileUpload> fileUploads = new ArrayList<FileUpload>();
            List fileItems = multipartWebRequest.getFile(this.parameterName);
            if (fileItems != null) {
                for (FileItem item : fileItems) {
                    fileUploads.add(new FileUpload(item));
                }
            }
            this.onFileUpload(target, fileUploads);
        }
        catch (FileUploadException fux) {
            this.onError(target, fux);
        }
    }

    public Bytes getMaxSize() {
        if (this.maxSize == null) {
            this.maxSize = this.getComponent().getApplication().getApplicationSettings().getDefaultMaximumUploadSize();
        }
        return this.maxSize;
    }

    public void setMaxSize(Bytes maxSize) {
        Args.notNull((Object)maxSize, (String)"maxSize");
        this.maxSize = maxSize;
    }

    public Bytes getFileMaxSize() {
        return this.fileMaxSize;
    }

    public void setFileMaxSize(Bytes fileMaxSize) {
        this.fileMaxSize = fileMaxSize;
    }

    public long getFileCountMax() {
        return this.fileCountMax;
    }

    public void setFileCountMax(long fileCountMax) {
        this.fileCountMax = fileCountMax;
    }

    protected void onFileUpload(AjaxRequestTarget target, List<FileUpload> files) {
    }

    protected void onError(AjaxRequestTarget target, FileUploadException fux) {
        throw new WicketRuntimeException((Throwable)fux);
    }
}

