/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.sort;

import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.version.undo.Change;

public class OrderByLink
extends Link {
    private static final long serialVersionUID = 1L;
    private final String property;
    private final ISortStateLocator stateLocator;

    public OrderByLink(String id, String property, ISortStateLocator stateLocator) {
        this(id, property, stateLocator, DefaultCssProvider.getInstance());
    }

    public OrderByLink(String id, String property, ISortStateLocator stateLocator, ICssProvider cssProvider) {
        super(id);
        if (cssProvider == null) {
            throw new IllegalArgumentException("argument [cssProvider] cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("argument [sortProperty] cannot be null");
        }
        this.property = property;
        this.stateLocator = stateLocator;
        this.add(new IBehavior[]{new CssModifier(this, cssProvider)});
    }

    public final void onClick() {
        this.sort();
        this.onSortChanged();
    }

    protected void onSortChanged() {
    }

    public final OrderByLink sort() {
        if (this.isVersioned()) {
            SortStateChange change = new SortStateChange();
            this.addStateChange(change);
        }
        ISortState state = this.stateLocator.getSortState();
        int oldDir = state.getPropertySortOrder(this.property);
        int newDir = 1;
        if (oldDir == 1) {
            newDir = -1;
        }
        state.setPropertySortOrder(this.property, newDir);
        return this;
    }

    public static class DefaultCssProvider
    extends CssProvider {
        private static final long serialVersionUID = 1L;
        private static DefaultCssProvider instance = new DefaultCssProvider();

        private DefaultCssProvider() {
            super("wicket_orderUp", "wicket_orderDown", "wicket_orderNone");
        }

        public static DefaultCssProvider getInstance() {
            return instance;
        }
    }

    public static class VoidCssProvider
    extends CssProvider {
        private static final long serialVersionUID = 1L;
        private static ICssProvider instance = new VoidCssProvider();

        public static ICssProvider getInstance() {
            return instance;
        }

        private VoidCssProvider() {
            super("", "", "");
        }
    }

    public static class CssProvider
    implements ICssProvider {
        private static final long serialVersionUID = 1L;
        private final String ascending;
        private final String descending;
        private final String none;

        public CssProvider(String ascending, String descending, String none) {
            this.ascending = ascending;
            this.descending = descending;
            this.none = none;
        }

        public String getClassAttributeValue(ISortState state, String property) {
            int dir = state.getPropertySortOrder(property);
            if (dir == 1) {
                return this.ascending;
            }
            if (dir == -1) {
                return this.descending;
            }
            return this.none;
        }
    }

    public static interface ICssProvider
    extends IClusterable {
        public String getClassAttributeValue(ISortState var1, String var2);
    }

    public static class CssModifier
    extends AbstractBehavior {
        private static final long serialVersionUID = 1L;
        private final OrderByLink link;
        private final ICssProvider provider;

        public CssModifier(OrderByLink link, ICssProvider provider) {
            this.link = link;
            this.provider = provider;
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            super.onComponentTag(component, tag);
            ISortState sortState = this.link.stateLocator.getSortState();
            String cssClass = this.provider.getClassAttributeValue(sortState, this.link.property);
            if (!Strings.isEmpty((CharSequence)cssClass)) {
                tag.append("class", (CharSequence)cssClass, " ");
            }
        }
    }

    private final class SortStateChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final ISortState old;

        private SortStateChange() {
            this.old = (ISortState)Objects.cloneModel((Object)OrderByLink.this.stateLocator.getSortState());
        }

        public void undo() {
            OrderByLink.this.stateLocator.setSortState(this.old);
        }

        public String toString() {
            return "[StateOrderChange old=" + this.old.toString() + "]";
        }
    }
}

