/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorLabel
extends Label {
    private static final long serialVersionUID = 1L;

    public NavigatorLabel(String id, final DataTable<?> table) {
        this(id, new PageableComponent(){
            private static final long serialVersionUID = 1L;

            public int getCurrentPage() {
                return table.getCurrentPage();
            }

            public int getRowCount() {
                return table.getRowCount();
            }

            public int getRowsPerPage() {
                return table.getRowsPerPage();
            }
        });
    }

    public NavigatorLabel(String id, final PageableListView<?> list) {
        this(id, new PageableComponent(){
            private static final long serialVersionUID = 1L;

            public int getCurrentPage() {
                return list.getCurrentPage();
            }

            public int getRowCount() {
                return list.getModelObject().size();
            }

            public int getRowsPerPage() {
                return list.getRowsPerPage();
            }
        });
    }

    public NavigatorLabel(String id, final DataView<?> table) {
        this(id, new PageableComponent(){
            private static final long serialVersionUID = 1L;

            public int getCurrentPage() {
                return table.getCurrentPage();
            }

            public int getRowCount() {
                return table.getRowCount();
            }

            public int getRowsPerPage() {
                return table.getItemsPerPage();
            }
        });
    }

    private NavigatorLabel(String id, PageableComponent table) {
        super(id);
        this.setDefaultModel((IModel)new StringResourceModel("NavigatorLabel", (Component)this, (IModel)new Model((Serializable)((Object)new LabelModelObject(table))), "Showing ${from} to ${to} of ${of}"));
    }

    private class LabelModelObject
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final PageableComponent table;

        public LabelModelObject(PageableComponent table) {
            this.table = table;
        }

        public int getOf() {
            return this.table.getRowCount();
        }

        public int getFrom() {
            if (this.getOf() == 0) {
                return 0;
            }
            return this.table.getCurrentPage() * this.table.getRowsPerPage() + 1;
        }

        public int getTo() {
            if (this.getOf() == 0) {
                return 0;
            }
            return Math.min(this.getOf(), this.getFrom() + this.table.getRowsPerPage() - 1);
        }
    }

    private static interface PageableComponent
    extends IClusterable {
        public int getRowCount();

        public int getCurrentPage();

        public int getRowsPerPage();
    }
}

