/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.version.undo.Change;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxLazyLoadPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private byte state = 0;

    public AjaxLazyLoadPanel(String id) {
        this(id, null);
    }

    public AjaxLazyLoadPanel(String id, IModel<?> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.add(new IBehavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                Component component = AjaxLazyLoadPanel.this.getLazyLoadComponent("content");
                AjaxLazyLoadPanel.this.replace(component.setRenderBodyOnly(true));
                target.addComponent((Component)AjaxLazyLoadPanel.this);
                AjaxLazyLoadPanel.this.setState((byte)2);
            }

            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                response.renderOnDomReadyJavascript(((Object)this.getCallbackScript()).toString());
            }

            public boolean isEnabled(Component component) {
                return AjaxLazyLoadPanel.this.state < 2;
            }
        }});
    }

    protected void onBeforeRender() {
        if (this.state == 0) {
            Component loadingComponent = this.getLoadingComponent("content");
            this.add(new Component[]{loadingComponent.setRenderBodyOnly(true)});
            this.setState((byte)1);
        }
        super.onBeforeRender();
    }

    private void setState(byte state) {
        if (this.state != state) {
            this.addStateChange(new StateChange(this.state));
        }
        this.state = state;
    }

    public abstract Component getLazyLoadComponent(String var1);

    public Component getLoadingComponent(String markupId) {
        return new Label(markupId, "<img src=\"" + RequestCycle.get().urlFor(AbstractDefaultAjaxBehavior.INDICATOR) + "\"/>").setEscapeModelStrings(false);
    }

    private final class StateChange
    extends Change {
        private static final long serialVersionUID = 1L;
        private final byte state;

        public StateChange(byte state) {
            this.state = state;
        }

        public void undo() {
            AjaxLazyLoadPanel.this.state = this.state;
        }
    }
}

