/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.filter;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.ChoiceFilter;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilterForm;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilteredPropertyColumn;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceFilteredPropertyColumn<T>
extends FilteredPropertyColumn<T> {
    private static final long serialVersionUID = 1L;
    private final IModel<List<? extends T>> filterChoices;

    public ChoiceFilteredPropertyColumn(IModel<String> displayModel, String sortProperty, String propertyExpression, IModel<List<? extends T>> filterChoices) {
        super(displayModel, sortProperty, propertyExpression);
        this.filterChoices = filterChoices;
    }

    public ChoiceFilteredPropertyColumn(IModel<String> displayModel, String propertyExpression, IModel<List<? extends T>> filterChoices) {
        super(displayModel, propertyExpression);
        this.filterChoices = filterChoices;
    }

    @Override
    public void detach() {
        super.detach();
        if (this.filterChoices != null) {
            this.filterChoices.detach();
        }
    }

    @Override
    public Component<T> getFilter(String componentId, FilterForm form) {
        ChoiceFilter<T> filter = new ChoiceFilter<T>(componentId, this.getFilterModel(form), form, this.filterChoices, this.enableAutoSubmit());
        IChoiceRenderer<T> renderer = this.getChoiceRenderer();
        if (renderer != null) {
            filter.getChoice().setChoiceRenderer(renderer);
        }
        return filter;
    }

    protected IModel<T> getFilterModel(FilterForm form) {
        return new PropertyModel((Object)form.getModel(), this.getPropertyExpression());
    }

    protected boolean enableAutoSubmit() {
        return true;
    }

    protected IChoiceRenderer<T> getChoiceRenderer() {
        return null;
    }

    protected final IModel<List<? extends T>> getFilterChoices() {
        return this.filterChoices;
    }
}

