/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.filter;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.AbstractFilter;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilterForm;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceFilter<T>
extends AbstractFilter<T> {
    private static final long serialVersionUID = 1L;
    private static final IChoiceRenderer defaultRenderer = new ChoiceRenderer();
    private final DropDownChoice<T> choice;

    public ChoiceFilter(String id, IModel<T> model, FilterForm form, IModel<List<? extends T>> choices, boolean autoSubmit) {
        this(id, model, form, choices, defaultRenderer, autoSubmit);
    }

    public ChoiceFilter(String id, IModel<T> model, FilterForm form, List<? extends T> choices, boolean autoSubmit) {
        this(id, model, form, (IModel<List<T>>)Model.valueOf(choices), (IChoiceRenderer<T>)defaultRenderer, autoSubmit);
    }

    public ChoiceFilter(String id, IModel<T> model, FilterForm form, List<? extends T> choices, IChoiceRenderer<T> renderer, boolean autoSubmit) {
        this(id, model, form, (IModel<List<T>>)Model.valueOf(choices), renderer, autoSubmit);
    }

    public ChoiceFilter(String id, IModel<T> model, FilterForm form, IModel<List<? extends T>> choices, IChoiceRenderer<T> renderer, boolean autoSubmit) {
        super(id, form);
        this.choice = this.newDropDownChoice("filter", model, choices, renderer);
        if (autoSubmit) {
            this.choice.add(new IBehavior[]{new AttributeModifier("onchange", true, (IModel)new Model((Serializable)((Object)"this.form.submit();")))});
        }
        this.enableFocusTracking((FormComponent<?>)this.choice);
        this.add(new Component[]{this.choice});
    }

    protected DropDownChoice<T> newDropDownChoice(String id, IModel<T> model, IModel<List<? extends T>> choices, IChoiceRenderer<T> renderer) {
        return new DropDownChoice(id, model, choices, renderer);
    }

    public DropDownChoice<T> getChoice() {
        return this.choice;
    }
}

