/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.select;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.form.select.IOptionRenderer;
import org.apache.wicket.extensions.markup.html.form.select.SelectOption;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOptions<T>
extends RepeatingView<Collection<? extends T>> {
    private static final long serialVersionUID = 1L;
    private boolean recreateChoices = false;
    private final IOptionRenderer<T> renderer;

    public SelectOptions(String id, IModel<Collection<? extends T>> model, IOptionRenderer<T> renderer) {
        super(id, model);
        this.renderer = renderer;
        this.setRenderBodyOnly(true);
    }

    public SelectOptions(String id, Collection<? extends T> elements, IOptionRenderer<T> renderer) {
        this(id, (IModel<Collection<T>>)new Model((Serializable)((Object)elements)), renderer);
    }

    public SelectOptions<T> setRecreateChoices(boolean refresh) {
        this.recreateChoices = refresh;
        return this;
    }

    protected final void onPopulate() {
        if (this.size() == 0 || this.recreateChoices) {
            this.removeAll();
            Collection modelObject = (Collection)this.getModelObject();
            if (modelObject != null) {
                if (!(modelObject instanceof Collection)) {
                    throw new WicketRuntimeException("Model object " + modelObject + " not a collection");
                }
                Iterator it = modelObject.iterator();
                while (it.hasNext()) {
                    WebMarkupContainer row = new WebMarkupContainer(this.newChildId());
                    row.setRenderBodyOnly(true);
                    this.add(new Component[]{row});
                    Object value = it.next();
                    String text = this.renderer.getDisplayValue(value);
                    IModel<T> model = this.renderer.getModel(value);
                    row.add(new Component[]{this.newOption(text, model)});
                }
            }
        }
    }

    protected SelectOption<T> newOption(String text, IModel<T> model) {
        return new SimpleSelectOption<T>("option", model, text);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleSelectOption<S>
    extends SelectOption<S> {
        private static final long serialVersionUID = 1L;
        private final String text;

        public SimpleSelectOption(String id, IModel<S> model, String text) {
            super(id, model);
            this.text = text;
        }

        protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            this.replaceComponentTagBody(markupStream, openTag, this.text);
        }
    }
}

