/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.palette.component;

import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.value.IValueMap;

public abstract class AbstractOptions
extends FormComponent {
    private static final long serialVersionUID = 1L;
    private Palette palette;

    protected Palette getPalette() {
        return this.palette;
    }

    public AbstractOptions(String id, Palette palette) {
        super(id);
        this.palette = palette;
        this.setOutputMarkupId(true);
    }

    protected abstract Iterator getOptionsIterator();

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        AppendingStringBuffer buffer = new AppendingStringBuffer(128);
        Iterator options = this.getOptionsIterator();
        IChoiceRenderer renderer = this.getPalette().getChoiceRenderer();
        while (options.hasNext()) {
            Object choice = options.next();
            String id = renderer.getIdValue(choice, 0);
            Object displayValue = renderer.getDisplayValue(choice);
            Class<?> displayClass = displayValue == null ? null : displayValue.getClass();
            String value = this.getConverter(displayClass).convertToString(displayValue, this.getLocale());
            value = this.getLocalizer().getString(id + "." + value, (Component)this, value);
            buffer.append("\n<option value=\"").append(id).append("\"");
            Map additionalAttributesMap = this.getAdditionalAttributes(choice);
            if (additionalAttributesMap != null) {
                for (String next : additionalAttributesMap.keySet()) {
                    buffer.append(" " + next + "=\"" + additionalAttributesMap.get(next).toString() + "\"");
                }
            }
            buffer.append(">").append(value).append("</option>");
        }
        buffer.append("\n");
        this.replaceComponentTagBody(markupStream, openTag, (CharSequence)buffer);
    }

    protected Map getAdditionalAttributes(Object choice) {
        return null;
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "select");
        super.onComponentTag(tag);
        IValueMap attrs = tag.getAttributes();
        attrs.put((Object)"multiple", null);
        attrs.put((Object)"size", (Object)new Integer(this.getPalette().getRows()));
        if (!this.palette.isPaletteEnabled()) {
            attrs.put((Object)"disabled", (Object)"disabled");
        }
        this.getResponse().write((CharSequence)("<script type=\"text/javascript\"><!--/*--><![CDATA[/*><!--*/\nif (typeof(Wicket) != \"undefined\" && typeof(Wicket.Form) != \"undefined\")    Wicket.Form.excludeFromAjaxSerialization." + this.getMarkupId() + "='true';" + "\n/*-->]]>*/</script>\n"));
    }

    public void updateModel() {
    }
}

