/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.extensions.breadcrumb.BreadCrumbModelListenerSupport;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModelListener;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;

public class DefaultBreadCrumbsModel
implements IBreadCrumbModel {
    private static final long serialVersionUID = 1L;
    private IBreadCrumbParticipant activeParticipant = null;
    private List crumbs = new ArrayList();
    private final BreadCrumbModelListenerSupport listenerSupport = new BreadCrumbModelListenerSupport();

    public final void addListener(IBreadCrumbModelListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public final List allBreadCrumbParticipants() {
        return this.crumbs;
    }

    public IBreadCrumbParticipant getActive() {
        return this.activeParticipant;
    }

    public final void removeListener(IBreadCrumbModelListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    public final void setActive(IBreadCrumbParticipant breadCrumbParticipant) {
        int len;
        for (int i = len = this.crumbs.size() - 1; i > -1; --i) {
            IBreadCrumbParticipant temp = (IBreadCrumbParticipant)this.crumbs.get(i);
            if (!breadCrumbParticipant.equals(temp)) continue;
            int j = len;
            while (j > i) {
                IBreadCrumbParticipant removed = (IBreadCrumbParticipant)this.crumbs.remove(j--);
                this.listenerSupport.fireBreadCrumbRemoved(removed);
            }
            this.activate(breadCrumbParticipant);
            return;
        }
        this.crumbs.add(breadCrumbParticipant);
        this.listenerSupport.fireBreadCrumbAdded(breadCrumbParticipant);
        this.activate(breadCrumbParticipant);
    }

    protected final void activate(IBreadCrumbParticipant breadCrumbParticipant) {
        IBreadCrumbParticipant previousParticipant = this.activeParticipant;
        this.activeParticipant = breadCrumbParticipant;
        this.listenerSupport.fireBreadCrumbActivated(previousParticipant, breadCrumbParticipant);
        breadCrumbParticipant.onActivate(previousParticipant);
    }
}

