/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.modal;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.CancelEventIfNoAjaxDecorator;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.util.lang.EnumeratedType;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class ModalWindow
extends Panel {
    private static final long serialVersionUID = 1L;
    private static ResourceReference JAVASCRIPT = new JavascriptResourceReference(ModalWindow.class, "res/modal.js");
    private static ResourceReference CSS = new CompressedResourceReference(ModalWindow.class, "res/modal.css");
    public static final String CSS_CLASS_BLUE = "w_blue";
    public static final String CSS_CLASS_GRAY = "w_silver";
    private boolean deletePageMap = false;
    private boolean shown = false;
    private WebMarkupContainer empty;
    private int minimalWidth = 200;
    private int minimalHeight = 200;
    private String cssClassName = "w_blue";
    private int initialWidth = 600;
    private int initialHeight = 400;
    private boolean useInitialHeight = true;
    private boolean resizable = true;
    private String widthUnit = "px";
    private String heightUnit = "px";
    private String cookieName;
    private IModel title = null;
    private MaskType maskType = MaskType.SEMI_TRANSPARENT;
    private String pageMapName = "modal-dialog-pagemap";
    private PageCreator pageCreator = null;
    private CloseButtonCallback closeButtonCallback = null;
    private WindowClosedCallback windowClosedCallback = null;

    public ModalWindow(String id) {
        super(id);
        this.setVersioned(false);
        this.cookieName = null;
        Component[] componentArray = new Component[1];
        this.empty = new WebMarkupContainer(this.getContentId());
        componentArray[0] = this.empty;
        this.add(componentArray);
        this.add(new IBehavior[]{new CloseButtonBehavior()});
        this.add(new IBehavior[]{new WindowClosedBehavior()});
        this.add(new IBehavior[]{HeaderContributor.forJavaScript((ResourceReference)JAVASCRIPT)});
        this.add(new IBehavior[]{HeaderContributor.forCss((ResourceReference)CSS)});
    }

    public boolean isShown() {
        return this.shown;
    }

    public void setPageMapName(String pageMapName) {
        this.pageMapName = pageMapName;
    }

    public String getPageMapName() {
        return this.pageMapName;
    }

    public void setPageCreator(PageCreator creator) {
        this.pageCreator = creator;
    }

    public void setCloseButtonCallback(CloseButtonCallback callback) {
        this.closeButtonCallback = callback;
    }

    public void setWindowClosedCallback(WindowClosedCallback callback) {
        this.windowClosedCallback = callback;
    }

    public void show(AjaxRequestTarget target) {
        if (!this.shown) {
            this.getContent().setVisible(true);
            target.addComponent((Component)this);
            target.appendJavascript(this.getWindowOpenJavascript());
            this.shown = true;
        }
    }

    public static final void closeCurrent(AjaxRequestTarget target) {
        target.appendJavascript(ModalWindow.getCloseJavacript());
    }

    public void close(AjaxRequestTarget target) {
        this.getContent().setVisible(false);
        target.appendJavascript(ModalWindow.getCloseJavacript());
        this.shown = false;
    }

    private static String getCloseJavacript() {
        return "var win;\ntry {\n\twin = window.parent.Wicket.Window;\n} catch (ignore) {\n}\nif (typeof(win) == \"undefined\" || typeof(win.current) == \"undefined\") {\n  try {\n     win = window.Wicket.Window;\n  } catch (ignore) {\n  }\n}\nif (typeof(win) != \"undefined\" && typeof(win.current) != \"undefined\") {\n\twindow.parent.setTimeout(function() {\n\t\twin.current.close();\n\t}, 0);\n}";
    }

    public String getContentId() {
        return "content";
    }

    public void setMinimalWidth(int minimalWidth) {
        this.minimalWidth = minimalWidth;
    }

    public int getMinimalWidth() {
        return this.minimalWidth;
    }

    public void setMinimalHeight(int minimalHeight) {
        this.minimalHeight = minimalHeight;
    }

    public int getMinimalHeight() {
        return this.minimalHeight;
    }

    public void setCssClassName(String cssClassName) {
        this.cssClassName = cssClassName;
    }

    public String getCssClassName() {
        return this.cssClassName;
    }

    public void setInitialWidth(int initialWidth) {
        this.initialWidth = initialWidth;
    }

    public int getInitialWidth() {
        return this.initialWidth;
    }

    public void setInitialHeight(int initialHeight) {
        this.initialHeight = initialHeight;
    }

    public int getInitialHeight() {
        return this.initialHeight;
    }

    public void setUseInitialHeight(boolean useInitialHeight) {
        this.useInitialHeight = useInitialHeight;
    }

    public boolean isUseInitialHeight() {
        return this.useInitialHeight;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setHeightUnit(String heightUnit) {
        this.heightUnit = heightUnit;
    }

    public String getHeightUnit() {
        return this.heightUnit;
    }

    public void setCookieName(String cookieName) {
        if (cookieName != null && cookieName.indexOf(",") != -1 && cookieName.indexOf("|") != -1) {
            throw new IllegalArgumentException("Cookie name may not contain ',' or '|' characters.");
        }
        this.cookieName = cookieName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setTitle(String title) {
        this.title = new Model((Serializable)((Object)title));
    }

    public void setTitle(IModel title) {
        this.title = title = this.wrap(title);
    }

    public IModel getTitle() {
        return this.title;
    }

    public void setMaskType(MaskType mask) {
        this.maskType = mask;
    }

    public MaskType getMaskType() {
        return this.maskType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page createPage() {
        if (this.pageCreator == null) {
            return null;
        }
        RequestParameters parameters = RequestCycle.get().getRequest().getRequestParameters();
        String oldPageMapName = parameters.getPageMapName();
        if (this.getPageMapName() != null) {
            Session session = Session.get();
            if (session.pageMapForName(this.getPageMapName(), false) == null) {
                this.deletePageMap = true;
            }
            parameters.setPageMapName(this.getPageMapName());
        }
        try {
            Page page;
            Page page2 = page = this.pageCreator.createPage();
            return page2;
        }
        finally {
            parameters.setPageMapName(oldPageMapName);
        }
    }

    protected void onBeforeRender() {
        if (!((WebRequest)this.getRequest()).isAjax()) {
            this.shown = false;
        }
        this.getContent().setOutputMarkupId(true);
        this.getContent().setVisible(this.shown);
        super.onBeforeRender();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("style", (CharSequence)"display:none");
    }

    private Component getContent() {
        return this.get(this.getContentId());
    }

    private boolean isCustomComponent() {
        return this.getContent() != this.empty;
    }

    public void remove(Component component) {
        super.remove(component);
        if (component.getId().equals(this.getContentId())) {
            Component[] componentArray = new Component[1];
            this.empty = new WebMarkupContainer(this.getContentId());
            componentArray[0] = this.empty;
            this.add(componentArray);
        }
    }

    public void setContent(Component component) {
        if (!component.getId().equals(this.getContentId())) {
            throw new WicketRuntimeException("Modal window content id is wrong.");
        }
        component.setOutputMarkupPlaceholderTag(true);
        component.setVisible(false);
        this.replace(component);
        this.shown = false;
    }

    private String getContentMarkupId() {
        return this.getContent().getMarkupId();
    }

    private String escapeQuotes(String string) {
        if (string.indexOf(34) != -1) {
            string = ((Object)Strings.replaceAll((CharSequence)string, (CharSequence)"\"", (CharSequence)"\\\"")).toString();
        }
        return string;
    }

    private String getWindowOpenJavascript() {
        AbstractDefaultAjaxBehavior behavior;
        Object title;
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        if (this.isCustomComponent()) {
            buffer.append("var element = document.getElementById(\"" + this.getContentMarkupId() + "\");\n");
        }
        buffer.append("var settings = new Object();\n");
        buffer.append("settings.minWidth=" + this.getMinimalWidth() + ";\n");
        buffer.append("settings.minHeight=" + this.getMinimalHeight() + ";\n");
        buffer.append("settings.className=\"" + this.getCssClassName() + "\";\n");
        buffer.append("settings.width=\"" + this.getInitialWidth() + "\";\n");
        if (this.isUseInitialHeight() || !this.isCustomComponent()) {
            buffer.append("settings.height=\"" + this.getInitialHeight() + "\";\n");
        } else {
            buffer.append("settings.height=null;\n");
        }
        buffer.append("settings.resizable=" + Boolean.toString(this.isResizable()) + ";\n");
        if (!this.isResizable()) {
            buffer.append("settings.widthUnit=\"" + this.getWidthUnit() + "\";\n");
            buffer.append("settings.heightUnit=\"" + this.getHeightUnit() + "\";\n");
        }
        if (!this.isCustomComponent()) {
            Page page = this.createPage();
            if (page == null) {
                throw new WicketRuntimeException("Error creating page for modal dialog.");
            }
            RequestCycle.get().setUrlForNewWindowEncoding();
            buffer.append("settings.src=\"" + RequestCycle.get().urlFor(page) + "\";\n");
            if (this.getPageMapName() != null) {
                buffer.append("settings.iframeName=\"" + this.getPageMapName() + "\";\n");
            }
        } else {
            buffer.append("settings.element = element;\n");
        }
        if (this.getCookieName() != null) {
            buffer.append("settings.cookieId=\"" + this.getCookieName() + "\";\n");
        }
        Object object = title = this.getTitle() != null ? this.getTitle().getObject() : null;
        if (title != null) {
            buffer.append("settings.title=\"" + this.escapeQuotes(title.toString()) + "\";\n");
        }
        if (this.getMaskType() == MaskType.TRANSPARENT) {
            buffer.append("settings.mask=\"transparent\";\n");
        } else if (this.getMaskType() == MaskType.SEMI_TRANSPARENT) {
            buffer.append("settings.mask=\"semi-transparent\";\n");
        }
        boolean haveCloseCallback = false;
        if (!this.isCustomComponent() && this.deletePageMap || this.windowClosedCallback != null) {
            behavior = (WindowClosedBehavior)((Object)this.getBehaviors(WindowClosedBehavior.class).get(0));
            buffer.append("settings.onClose = function() { " + behavior.getCallbackScript() + " };\n");
            haveCloseCallback = true;
        }
        if (this.closeButtonCallback != null || !haveCloseCallback) {
            behavior = (CloseButtonBehavior)((Object)this.getBehaviors(CloseButtonBehavior.class).get(0));
            buffer.append("settings.onCloseButton = function() { " + behavior.getCallbackScript() + "};\n");
        }
        this.postProcessSettings(buffer);
        buffer.append("Wicket.Window.create(settings).show();\n");
        return buffer.toString();
    }

    protected AppendingStringBuffer postProcessSettings(AppendingStringBuffer settings) {
        return settings;
    }

    protected void onDetach() {
        super.onDetach();
        if (this.title != null) {
            this.title.detach();
        }
    }

    private class CloseButtonBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private CloseButtonBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            if (ModalWindow.this.closeButtonCallback == null || ModalWindow.this.closeButtonCallback.onCloseButtonClicked(target)) {
                ModalWindow.this.close(target);
            }
        }

        protected IAjaxCallDecorator getAjaxCallDecorator() {
            return new CancelEventIfNoAjaxDecorator(super.getAjaxCallDecorator());
        }

        protected CharSequence getCallbackScript() {
            return super.getCallbackScript();
        }
    }

    private class WindowClosedBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private WindowClosedBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            Session session;
            IPageMap pageMap;
            ModalWindow.this.shown = false;
            if (ModalWindow.this.deletePageMap && (pageMap = (session = Session.get()).pageMapForName(ModalWindow.this.getPageMapName(), false)) != null) {
                session.removePageMap(pageMap);
                ModalWindow.this.deletePageMap = false;
            }
            if (ModalWindow.this.windowClosedCallback != null) {
                ModalWindow.this.windowClosedCallback.onClose(target);
            }
        }

        protected CharSequence getCallbackScript() {
            return super.getCallbackScript();
        }
    }

    public static final class MaskType
    extends EnumeratedType {
        private static final long serialVersionUID = 1L;
        public static final MaskType TRANSPARENT = new MaskType("TRANSPARENT");
        public static final MaskType SEMI_TRANSPARENT = new MaskType("SEMI_TRANSPARENT");

        public MaskType(String name) {
            super(name);
        }
    }

    public static interface WindowClosedCallback
    extends IClusterable {
        public void onClose(AjaxRequestTarget var1);
    }

    public static interface CloseButtonCallback
    extends IClusterable {
        public boolean onCloseButtonClicked(AjaxRequestTarget var1);
    }

    public static interface PageCreator
    extends IClusterable {
        public Page createPage();
    }
}

