/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import java.util.Iterator;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.StringAutoCompleteRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoCompleteTextField<T>
extends TextField<T> {
    private static final long serialVersionUID = 1L;

    public AutoCompleteTextField(String id, Class<T> type) {
        this(id, (IModel)null, type, new AutoCompleteSettings());
    }

    @Deprecated
    public AutoCompleteTextField(String id, IModel<T> model, Class<T> type, boolean preselect) {
        this(id, model, type, StringAutoCompleteRenderer.INSTANCE, new AutoCompleteSettings().setPreselect(preselect));
    }

    public AutoCompleteTextField(String id, IModel<T> model, Class<T> type, AutoCompleteSettings settings) {
        this(id, model, type, StringAutoCompleteRenderer.INSTANCE, settings);
    }

    @Deprecated
    public AutoCompleteTextField(String id, IModel<T> object, boolean preselect) {
        this(id, object, (Class)null, new AutoCompleteSettings().setPreselect(preselect));
    }

    public AutoCompleteTextField(String id, IModel<T> object, AutoCompleteSettings settings) {
        this(id, object, (Class)null, settings);
    }

    public AutoCompleteTextField(String id, IModel<T> object) {
        this(id, object, (Class)null, new AutoCompleteSettings());
    }

    @Deprecated
    public AutoCompleteTextField(String id, boolean preselect) {
        this(id, (IModel)null, new AutoCompleteSettings().setPreselect(preselect));
    }

    public AutoCompleteTextField(String id, AutoCompleteSettings settings) {
        this(id, (IModel)null, settings);
    }

    public AutoCompleteTextField(String id) {
        this(id, (IModel)null, new AutoCompleteSettings());
    }

    public AutoCompleteTextField(String id, IAutoCompleteRenderer<T> renderer) {
        this(id, (IModel)null, renderer);
    }

    public AutoCompleteTextField(String id, Class<T> type, IAutoCompleteRenderer<T> renderer) {
        this(id, null, type, renderer, new AutoCompleteSettings());
    }

    public AutoCompleteTextField(String id, IModel<T> model, IAutoCompleteRenderer<T> renderer) {
        this(id, model, (Class)null, renderer, new AutoCompleteSettings());
    }

    @Deprecated
    public AutoCompleteTextField(String id, IModel<T> model, Class<T> type, IAutoCompleteRenderer<T> renderer, boolean preselect) {
        this(id, model, type, renderer, new AutoCompleteSettings().setPreselect(preselect));
    }

    public AutoCompleteTextField(String id, IModel<T> model, Class<T> type, IAutoCompleteRenderer<T> renderer, AutoCompleteSettings settings) {
        super(id, model, type);
        this.add(new IBehavior[]{new SimpleAttributeModifier("autocomplete", (CharSequence)"off")});
        this.add(new IBehavior[]{new AutoCompleteBehavior<T>(renderer, settings){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator<T> getChoices(String input) {
                return AutoCompleteTextField.this.getChoices(input);
            }
        }});
    }

    protected abstract Iterator<T> getChoices(String var1);
}

