/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import org.apache.wicket.Response;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutoCompleteRenderer<T>
implements IAutoCompleteRenderer<T> {
    private static final long serialVersionUID = 1L;

    @Override
    public final void render(T object, Response response, String criteria) {
        String textValue = this.getTextValue(object);
        if (textValue == null) {
            throw new IllegalStateException("A call to textValue(Object) returned an illegal value: null for object: " + object.toString());
        }
        textValue = textValue.replaceAll("\\\"", "&quot;");
        response.write((CharSequence)("<li textvalue=\"" + textValue + "\">"));
        this.renderChoice(object, response, criteria);
        response.write((CharSequence)"</li>");
    }

    @Override
    public final void renderHeader(Response response) {
        response.write((CharSequence)"<ul>");
    }

    @Override
    public final void renderFooter(Response response) {
        response.write((CharSequence)"</ul>");
    }

    protected abstract void renderChoice(T var1, Response var2, String var3);

    protected abstract String getTextValue(T var1);
}

