/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketAjaxIndicatorAppender
extends AbstractBehavior {
    private Component<?> component;
    private static final long serialVersionUID = 1L;

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (AjaxRequestTarget.get() != null) {
            String javascript = "var e = Wicket.$('" + this.getMarkupId() + "'); if (e != null && typeof(e.parentNode) != 'undefined') e.parentNode.removeChild(e);";
            response.renderJavascript((CharSequence)javascript, null);
        }
    }

    public void onRendered(Component<?> component) {
        Response r = component.getResponse();
        r.write((CharSequence)"<span style=\"display:none;\" class=\"");
        r.write((CharSequence)this.getSpanClass());
        r.write((CharSequence)"\" ");
        r.write((CharSequence)"id=\"");
        r.write((CharSequence)this.getMarkupId());
        r.write((CharSequence)"\">");
        r.write((CharSequence)"<img src=\"");
        r.write(this.getIndicatorUrl());
        r.write((CharSequence)"\" alt=\"\"/></span>");
    }

    protected CharSequence getIndicatorUrl() {
        return RequestCycle.get().urlFor(AbstractDefaultAjaxBehavior.INDICATOR);
    }

    protected String getSpanClass() {
        return "wicket-ajax-indicator";
    }

    public String getMarkupId() {
        return this.component.getMarkupId() + "--ajax-indicator";
    }

    public final void bind(Component<?> component) {
        this.component = component;
    }
}

