/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class AjaxLazyLoadPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public AjaxLazyLoadPanel(String id) {
        this(id, null);
    }

    public AjaxLazyLoadPanel(String id, IModel model) {
        super(id, model);
        this.setOutputMarkupId(true);
        final Component loadingComponent = this.getLoadingComponent("content");
        this.add(new Component[]{loadingComponent.setRenderBodyOnly(true)});
        this.add(new IBehavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                Component component = AjaxLazyLoadPanel.this.getLazyLoadComponent("content");
                AjaxLazyLoadPanel.this.replace(component.setRenderBodyOnly(true));
                target.addComponent((Component)AjaxLazyLoadPanel.this);
            }

            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                response.renderOnDomReadyJavascript(((Object)this.getCallbackScript()).toString());
            }

            public boolean isEnabled(Component component) {
                return AjaxLazyLoadPanel.this.get("content") == loadingComponent;
            }
        }});
    }

    public abstract Component getLazyLoadComponent(String var1);

    public Component getLoadingComponent(String markupId) {
        return new Label(markupId, "<img src=\"" + RequestCycle.get().urlFor(AbstractDefaultAjaxBehavior.INDICATOR) + "\"/>").setEscapeModelStrings(false);
    }
}

