/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.rating;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public abstract class RatingPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference STAR0 = new ResourceReference(RatingPanel.class, "star0.gif");
    public static final ResourceReference STAR1 = new ResourceReference(RatingPanel.class, "star1.gif");
    private IModel nrOfStars = new Model((Serializable)new Integer(5));
    private IModel nrOfVotes;
    private IModel hasVoted;
    private Component ratingLabel;

    public RatingPanel(String id) {
        this(id, null, 5, true);
    }

    public RatingPanel(String id, IModel rating) {
        this(id, rating, (IModel)new Model((Serializable)new Integer(5)), null, (IModel)new Model((Serializable)Boolean.FALSE), true);
    }

    public RatingPanel(String id, int nrOfStars) {
        this(id, null, nrOfStars, true);
    }

    public RatingPanel(String id, IModel rating, int nrOfStars, boolean addDefaultCssStyle) {
        this(id, rating, (IModel)new Model((Serializable)new Integer(nrOfStars)), null, (IModel)new Model((Serializable)Boolean.FALSE), addDefaultCssStyle);
    }

    public RatingPanel(String id, IModel rating, int nrOfStars, IModel nrOfVotes, boolean addDefaultCssStyle) {
        this(id, rating, (IModel)new Model((Serializable)new Integer(nrOfStars)), nrOfVotes, (IModel)new Model((Serializable)Boolean.FALSE), addDefaultCssStyle);
    }

    public RatingPanel(String id, IModel rating, IModel nrOfStars, IModel nrOfVotes, IModel hasVoted, boolean addDefaultCssStyle) {
        super(id, rating);
        this.nrOfStars = nrOfStars;
        this.nrOfVotes = nrOfVotes;
        this.hasVoted = hasVoted;
        WebMarkupContainer rater = new WebMarkupContainer("rater");
        rater.add(this.newRatingStarBar("element", nrOfStars));
        this.ratingLabel = this.newRatingLabel("rating", rating, nrOfVotes);
        rater.add(this.ratingLabel);
        rater.setOutputMarkupId(true);
        this.add((Component)rater);
        this.setRenderBodyOnly(true);
        if (addDefaultCssStyle) {
            this.addDefaultCssStyle();
        }
    }

    public final void addDefaultCssStyle() {
        this.add((IBehavior)HeaderContributor.forCss((Class)RatingPanel.class, (String)"RatingPanel.css"));
    }

    protected Component newRatingStarBar(String id, IModel nrOfStars) {
        return new RatingStarBar(id, nrOfStars);
    }

    protected Component newRatingLabel(String id, IModel rating, IModel nrOfVotes) {
        StringResourceModel model = null;
        if (nrOfVotes == null) {
            Object[] parameters = new Object[]{rating};
            model = new StringResourceModel("rating.simple", (Component)this, null, parameters);
        } else {
            Object[] parameters = new Object[]{rating, nrOfVotes};
            model = new StringResourceModel("rating.complete", (Component)this, null, parameters);
        }
        return new Label(id, (IModel)model);
    }

    protected String getActiveStarUrl(int iteration) {
        return ((Object)this.getRequestCycle().urlFor(STAR1)).toString();
    }

    protected String getInactiveStarUrl(int iteration) {
        return ((Object)this.getRequestCycle().urlFor(STAR0)).toString();
    }

    public RatingPanel setRatingLabelVisible(boolean visible) {
        this.ratingLabel.setVisible(visible);
        return this;
    }

    protected abstract boolean onIsStarActive(int var1);

    protected abstract void onRated(int var1, AjaxRequestTarget var2);

    private final class RatingStarBar
    extends Loop {
        private static final long serialVersionUID = 1L;

        private RatingStarBar(String id, IModel model) {
            super(id, model);
        }

        protected void populateItem(Loop.LoopItem item) {
            AjaxFallbackLink link = new AjaxFallbackLink("link"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    Loop.LoopItem item = (Loop.LoopItem)this.getParent();
                    RatingPanel.this.onRated(item.getIteration() + 1, target);
                    if (target != null) {
                        target.addComponent(RatingPanel.this.get("rater"));
                    }
                }

                public boolean isEnabled() {
                    return (Boolean)RatingPanel.this.hasVoted.getObject() == false;
                }
            };
            int iteration = item.getIteration();
            link.add(new WebMarkupContainer("star").add((IBehavior)new SimpleAttributeModifier("src", (CharSequence)(RatingPanel.this.onIsStarActive(iteration) ? RatingPanel.this.getActiveStarUrl(iteration) : RatingPanel.this.getInactiveStarUrl(iteration)))));
            item.add((Component)link);
        }
    }
}

