/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tabs;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TabbedPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String TAB_PANEL_ID = "panel";
    private final List tabs;

    public TabbedPanel(String id, List tabs) {
        super(id, (IModel)new Model((Serializable)new Integer(-1)));
        if (tabs == null) {
            throw new IllegalArgumentException("argument [tabs] cannot be null");
        }
        this.tabs = tabs;
        AbstractReadOnlyModel tabCount = new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                return new Integer(TabbedPanel.this.tabs.size());
            }
        };
        WebMarkupContainer tabsContainer = new WebMarkupContainer("tabs-container"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("class", (CharSequence)TabbedPanel.this.getTabContainerCssClass());
            }
        };
        this.add((Component)tabsContainer);
        tabsContainer.add((Component)new Loop("tabs", (IModel)tabCount){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Loop.LoopItem item) {
                int index = item.getIteration();
                ITab tab = (ITab)TabbedPanel.this.tabs.get(index);
                WebMarkupContainer titleLink = TabbedPanel.this.newLink("link", index);
                titleLink.add(TabbedPanel.this.newTitle("title", tab.getTitle(), index));
                item.add((Component)titleLink);
            }

            protected Loop.LoopItem newItem(int iteration) {
                return TabbedPanel.this.newTabContainer(iteration);
            }
        });
    }

    protected Loop.LoopItem newTabContainer(int tabIndex) {
        return new Loop.LoopItem(tabIndex){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClass = (String)tag.getString("class");
                if (cssClass == null) {
                    cssClass = " ";
                }
                cssClass = cssClass + " tab" + this.getIteration();
                if (this.getIteration() == TabbedPanel.this.getSelectedTab()) {
                    cssClass = cssClass + " selected";
                }
                if (this.getIteration() == TabbedPanel.this.getTabs().size() - 1) {
                    cssClass = cssClass + " last";
                }
                tag.put("class", (CharSequence)cssClass.trim());
            }
        };
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (!this.hasBeenRendered() && this.getSelectedTab() == -1) {
            this.setSelectedTab(0);
        }
    }

    protected String getTabContainerCssClass() {
        return "tab-row";
    }

    public final List getTabs() {
        return this.tabs;
    }

    protected Component newTitle(String titleId, IModel titleModel, int index) {
        return new Label(titleId, titleModel);
    }

    protected WebMarkupContainer newLink(String linkId, final int index) {
        return new Link(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                TabbedPanel.this.setSelectedTab(index);
            }
        };
    }

    public final void setSelectedTab(int index) {
        if (index < 0 || index >= this.tabs.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.setModelObject(new Integer(index));
        ITab tab = (ITab)this.tabs.get(index);
        Panel panel = tab.getPanel(TAB_PANEL_ID);
        if (panel == null) {
            throw new WicketRuntimeException("ITab.getPanel() returned null. TabbedPanel [" + this.getPath() + "] ITab index [" + index + "]");
        }
        if (!panel.getId().equals(TAB_PANEL_ID)) {
            throw new WicketRuntimeException("ITab.getPanel() returned a panel with invalid id [" + panel.getId() + "]. You must always return a panel with id equal to the provided panelId parameter. TabbedPanel [" + this.getPath() + "] ITab index [" + index + "]");
        }
        if (this.get(TAB_PANEL_ID) == null) {
            this.add((Component)panel);
        } else {
            this.replace((Component)panel);
        }
    }

    public final int getSelectedTab() {
        return (Integer)this.getModelObject();
    }
}

