/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.pagestore.browser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.pageStore.DefaultPageContext;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPersistentPageStore;

public class SessionIdentifiersModel
extends LoadableDetachableModel<List<String>> {
    private final IModel<IPersistentPageStore> store;

    public SessionIdentifiersModel(IModel<IPersistentPageStore> store) {
        this.store = store;
    }

    protected List<String> load() {
        DefaultPageContext context;
        String current;
        IPersistentPageStore store = (IPersistentPageStore)this.store.getObject();
        if (store == null) {
            return Collections.emptyList();
        }
        ArrayList<String> identifiers = new ArrayList<String>(store.getSessionIdentifiers());
        if (!identifiers.contains(current = store.getSessionIdentifier((IPageContext)(context = new DefaultPageContext())))) {
            identifiers.add(current);
        }
        return identifiers;
    }

    public void detach() {
        super.detach();
        this.store.detach();
    }
}

