/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.diskstore;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.wicket.Application;
import org.apache.wicket.devutils.diskstore.DebugDiskDataStore;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.pageStore.PageWindowManager;
import org.apache.wicket.serialize.ISerializer;

class PageWindowModel
extends AbstractReadOnlyModel<DefaultTreeModel> {
    private final DefaultTreeModel treeModel;

    public PageWindowModel(String sessionId, DebugDiskDataStore dataStore) {
        List<PageWindowManager.PageWindow> pageWindows = dataStore.getLastPageWindows(sessionId, 50);
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.initialize(rootNode, pageWindows, dataStore, sessionId);
        this.treeModel = new DefaultTreeModel(rootNode);
    }

    public DefaultTreeModel getObject() {
        return this.treeModel;
    }

    private void initialize(DefaultMutableTreeNode root, List<PageWindowManager.PageWindow> pageWindows, DebugDiskDataStore dataStore, String sessionId) {
        ISerializer serializer = Application.get().getFrameworkSettings().getSerializer();
        for (PageWindowManager.PageWindow pageWindow : pageWindows) {
            int pageId = pageWindow.getPageId();
            DefaultMutableTreeNode pageIdNode = new DefaultMutableTreeNode(pageId);
            root.add(pageIdNode);
            byte[] data = dataStore.getData(sessionId, pageId);
            Object page = serializer.deserialize(data);
            DefaultMutableTreeNode pageNameNode = new DefaultMutableTreeNode(page.getClass().getName());
            pageIdNode.add(pageNameNode);
            DefaultMutableTreeNode pageSizeNode = new DefaultMutableTreeNode("Size: " + data.length + " bytes");
            pageIdNode.add(pageSizeNode);
        }
    }
}

