/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.inspector;

import java.io.Serializable;
import org.apache.wicket.Session;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.lang.Bytes;

public class SessionSizeModel
extends LoadableDetachableModel<Bytes> {
    private static final long serialVersionUID = 1L;
    private Session session;

    public SessionSizeModel(Session session) {
        this.session = session;
    }

    protected Bytes load() {
        long sizeOfSession = WicketObjects.sizeof((Serializable)this.session);
        return sizeOfSession > -1L ? Bytes.bytes((long)sizeOfSession) : null;
    }

    protected void onDetach() {
        super.onDetach();
        this.session = null;
    }
}

