/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.debugbar;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.devutils.DevUtilsPanel;
import org.apache.wicket.devutils.debugbar.IDebugBarContributor;
import org.apache.wicket.devutils.debugbar.InspectorDebugPanel;
import org.apache.wicket.devutils.debugbar.SessionSizeDebugPanel;
import org.apache.wicket.devutils.debugbar.VersionDebugContributor;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CompressedResourceReference;
import org.apache.wicket.request.resource.JavascriptResourceReference;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugBar
extends DevUtilsPanel {
    private static final MetaDataKey<List<IDebugBarContributor>> CONTRIBS_META_KEY = new MetaDataKey<List<IDebugBarContributor>>(){
        private static final long serialVersionUID = 1L;
    };
    private static final long serialVersionUID = 1L;

    public DebugBar(String id) {
        super(id);
        this.setMarkupId("wicketDebugBar");
        this.setOutputMarkupId(true);
        this.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return "wicketDebugBar" + (DebugBar.this.hasErrorMessage() ? "Error" : "");
            }
        })});
        this.add(new IBehavior[]{HeaderContributor.forCss((ResourceReference)new CompressedResourceReference(DebugBar.class, "wicket-debugbar.css"))});
        this.add(new IBehavior[]{HeaderContributor.forJavaScript((ResourceReference)new JavascriptResourceReference(DebugBar.class, "wicket-debugbar.js"))});
        this.add(new Component[]{new Image("logo", (ResourceReference)new PackageResourceReference(DebugBar.class, "wicket.png"))});
        this.add(new Component[]{new Image("removeImg", (ResourceReference)new PackageResourceReference(DebugBar.class, "remove.png"))});
        List<IDebugBarContributor> contributors = DebugBar.getContributors();
        this.add(new Component[]{new ListView<IDebugBarContributor>("contributors", contributors){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<IDebugBarContributor> item) {
                IDebugBarContributor contrib = (IDebugBarContributor)item.getModelObject();
                Component comp = contrib.createComponent("contrib", DebugBar.this);
                if (comp == null) {
                    item.setVisibilityAllowed(false);
                } else {
                    item.add(new Component[]{comp});
                }
            }
        }});
    }

    public boolean isVisible() {
        return this.getApplication().getDebugSettings().isDevelopmentUtilitiesEnabled();
    }

    public static void registerContributor(IDebugBarContributor contrib) {
        DebugBar.registerContributor(contrib, Application.get());
    }

    public static void registerContributor(IDebugBarContributor contrib, Application application) {
        if (contrib == null) {
            throw new IllegalArgumentException("contrib can not be null");
        }
        List<IDebugBarContributor> contributors = DebugBar.getContributors(application);
        contributors.add(contrib);
        application.setMetaData(CONTRIBS_META_KEY, contributors);
    }

    private static List<IDebugBarContributor> getContributors() {
        return DebugBar.getContributors(Application.get());
    }

    private static List<IDebugBarContributor> getContributors(Application application) {
        List list = (List)application.getMetaData(CONTRIBS_META_KEY);
        return list == null ? new ArrayList() : list;
    }

    static void registerStandardContributors(Application application) {
        DebugBar.registerContributor(VersionDebugContributor.DEBUG_BAR_CONTRIB, application);
        DebugBar.registerContributor(InspectorDebugPanel.DEBUG_BAR_CONTRIB, application);
        DebugBar.registerContributor(SessionSizeDebugPanel.DEBUG_BAR_CONTRIB, application);
    }
}

