/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.inspector;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.devutils.DevUtilsPage;
import org.apache.wicket.devutils.inspector.ApplicationView;
import org.apache.wicket.devutils.inspector.RequestsPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.RequestLogger;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.lang.Bytes;

public class LiveSessionsPage
extends DevUtilsPage {
    private static final long serialVersionUID = 1L;

    public LiveSessionsPage() {
        this.add(new Component[]{new Image("bug")});
        this.add(new Component[]{new ApplicationView("application", Application.get())});
        Link<Void> link = new Link<Void>("togglelink"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                WebApplication webApplication = (WebApplication)Application.get();
                webApplication.getRequestLoggerSettings().setRequestsWindowSize(500);
                boolean enabled = webApplication.getRequestLoggerSettings().isRequestLoggerEnabled();
                webApplication.getRequestLoggerSettings().setRequestLoggerEnabled(!enabled);
            }
        };
        link.add(new Component[]{new Label("toggletext", (IModel)new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                WebApplication webApplication = (WebApplication)Application.get();
                IRequestLogger requestLogger = webApplication.getRequestLogger();
                if (requestLogger == null) {
                    return "Enable request recording";
                }
                return "Disable request recording";
            }
        })});
        this.add(new Component[]{link});
        this.add(new Component[]{new Label("totalSessions", (IModel)new Model<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return LiveSessionsPage.this.getRequestLogger().getTotalCreatedSessions();
            }
        })});
        this.add(new Component[]{new Label("peakSessions", (IModel)new Model<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return LiveSessionsPage.this.getRequestLogger().getPeakSessions();
            }
        })});
        this.add(new Component[]{new Label("liveSessions", (IModel)new Model<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return LiveSessionsPage.this.getRequestLogger().getPeakSessions();
            }
        })});
        AbstractReadOnlyModel<List<RequestLogger.SessionData>> sessionModel = new AbstractReadOnlyModel<List<RequestLogger.SessionData>>(){
            private static final long serialVersionUID = 1L;

            public List<RequestLogger.SessionData> getObject() {
                return new ArrayList<RequestLogger.SessionData>(Arrays.asList(LiveSessionsPage.this.getRequestLogger().getLiveSessions()));
            }
        };
        PageableListView<RequestLogger.SessionData> listView = new PageableListView<RequestLogger.SessionData>("sessions", (IModel)sessionModel, 50){
            private static final long serialVersionUID = 1L;
            private final SimpleDateFormat sdf;
            {
                this.sdf = new SimpleDateFormat("dd MMM hh:mm:ss.SSS");
            }

            protected void populateItem(ListItem<RequestLogger.SessionData> item) {
                final RequestLogger.SessionData sd = (RequestLogger.SessionData)item.getModelObject();
                Link<Void> link = new Link<Void>("id"){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        this.setResponsePage((Page)new RequestsPage(sd));
                    }
                };
                link.add(new Component[]{new Label("id", (IModel)new Model((Serializable)((Object)sd.getSessionId())))});
                item.add(new Component[]{link});
                item.add(new Component[]{new Label("lastRequestTime", (IModel)new Model((Serializable)((Object)this.sdf.format(sd.getLastActive()))))});
                item.add(new Component[]{new Label("requestCount", (IModel)new Model((Serializable)Long.valueOf(sd.getNumberOfRequests())))});
                item.add(new Component[]{new Label("requestsTime", (IModel)new Model((Serializable)Long.valueOf(sd.getTotalTimeTaken())))});
                item.add(new Component[]{new Label("sessionSize", (IModel)new Model((Serializable)Bytes.bytes((long)sd.getSessionSize())))});
            }
        };
        this.add(new Component[]{listView});
        PagingNavigator navigator = new PagingNavigator("navigator", (IPageable)listView);
        this.add(new Component[]{navigator});
    }

    IRequestLogger getRequestLogger() {
        WebApplication webApplication = (WebApplication)Application.get();
        Object requestLogger = webApplication.getRequestLogger() == null ? new RequestLogger() : webApplication.getRequestLogger();
        return requestLogger;
    }
}

