/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.stateless;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.apache.wicket.devutils.stateless.StatelessComponent;

public class StatelessChecker
implements IComponentOnBeforeRenderListener {
    private static boolean mustCheck(Component component) {
        StatelessComponent ann = component.getClass().getAnnotation(StatelessComponent.class);
        return ann != null && ann.enabled();
    }

    public void onBeforeRender(final Component component) {
        if (StatelessChecker.mustCheck(component)) {
            Object o;
            Component.IVisitor<Component> visitor = new Component.IVisitor<Component>(){

                public Object component(Component comp) {
                    if (component instanceof Page && StatelessChecker.mustCheck(comp)) {
                        return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
                    }
                    if (!comp.isStateless()) {
                        return comp;
                    }
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
            };
            String msg = "'" + component + "' claims to be stateless but isn't.";
            if (!component.isStateless()) {
                throw new IllegalArgumentException(msg + " Possible reasons: no stateless hint, statefull behaviors");
            }
            if (component instanceof MarkupContainer && (o = ((MarkupContainer)component).visitChildren((Component.IVisitor)visitor)) == null) {
                throw new IllegalArgumentException(msg + " Offending component: " + o);
            }
            if (component instanceof Page) {
                Page p = (Page)component;
                if (!p.isBookmarkable()) {
                    throw new IllegalArgumentException(msg + " Only bookmarkable pages can be stateless");
                }
                if (!p.isPageStateless()) {
                    throw new IllegalArgumentException(msg + " for unknown reason");
                }
            }
        }
    }
}

