/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.inspector;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.wicket.AccessStackPageMap;
import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.devutils.DevUtilsPanel;
import org.apache.wicket.devutils.inspector.InspectorPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.session.pagemap.IPageMapEntry;
import org.apache.wicket.util.collections.ArrayListStack;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Objects;

public final class PageMapView
extends DevUtilsPanel {
    private static final long serialVersionUID = 1L;

    public PageMapView(String id, final IPageMap pageMap) {
        super(id);
        this.add(new Component[]{new Label("name", pageMap.getName() == null ? "null" : pageMap.getName())});
        this.add(new Component[]{new Label("size", "" + Bytes.bytes((long)pageMap.getSizeInBytes()))});
        final ArrayListStack accessStack = pageMap instanceof AccessStackPageMap ? ((AccessStackPageMap)pageMap).getAccessStack() : new ArrayListStack();
        ArrayList reversedAccessStack = new ArrayList();
        reversedAccessStack.addAll(accessStack);
        Collections.reverse(reversedAccessStack);
        this.add(new Component[]{new ListView<AccessStackPageMap.Access>("accesses", reversedAccessStack){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<AccessStackPageMap.Access> listItem) {
                int versions;
                long size;
                AccessStackPageMap.Access access = (AccessStackPageMap.Access)listItem.getModelObject();
                IPageMapEntry entry = pageMap.getEntry(access.getId());
                PageParameters parameters = new PageParameters();
                parameters.put("pageId", (Object)("" + entry.getNumericId()));
                BookmarkablePageLink link = new BookmarkablePageLink("link", InspectorPage.class, parameters);
                link.add(new Component[]{new Label("id", "" + entry.getNumericId())});
                listItem.add(new Component[]{link});
                listItem.add(new Component[]{new Label("class", "" + entry.getClass().getName())});
                if (entry instanceof Page) {
                    Page page = (Page)entry;
                    page.detachModels();
                    size = page.getSizeInBytes();
                    versions = page.getVersions();
                } else {
                    size = Objects.sizeof((Object)entry);
                    versions = 0;
                }
                listItem.add(new Component[]{new Label("access", "" + (accessStack.size() - listItem.getIndex()))});
                listItem.add(new Component[]{new Label("version", "" + access.getVersion())});
                listItem.add(new Component[]{new Label("versions", "" + versions)});
                listItem.add(new Component[]{new Label("size", size == -1L ? "[Unknown]" : "" + Bytes.bytes((long)size))});
            }
        }});
    }
}

