/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.inspector;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Session;
import org.apache.wicket.devutils.DevUtilsPage;
import org.apache.wicket.devutils.inspector.ApplicationView;
import org.apache.wicket.devutils.inspector.LiveSessionsPage;
import org.apache.wicket.devutils.inspector.SessionView;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.debug.PageView;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.session.pagemap.IPageMapEntry;
import org.apache.wicket.util.string.StringValueConversionException;

public final class InspectorPage
extends DevUtilsPage {
    private static final long serialVersionUID = 1L;

    public InspectorPage(PageParameters parameters) {
        this.add(new Component[]{new ApplicationView("application", Application.get())});
        this.add(new Component[]{new SessionView("session", Session.get())});
        IPageMapEntry entry = null;
        try {
            entry = this.getPageMap().getEntry(parameters.getInt("pageId"));
        }
        catch (StringValueConversionException stringValueConversionException) {
            // empty catch block
        }
        this.add(new Component[]{new PageView("page", entry == null ? null : entry.getPage())});
        this.add(new Component[]{new Image("bug")});
        this.add(new Component[]{new BookmarkablePageLink("allsessions", LiveSessionsPage.class)});
        this.add(new Component[]{new Label("wicketVersion", this.getApplication().getFrameworkSettings().getVersion())});
    }

    public boolean isVersioned() {
        return false;
    }
}

