/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webservices;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.cxf.rs.CxfRsHttpListener;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.util.HttpUtil;
import org.apache.openejb.server.rest.RsRegistry;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomee.catalina.environment.Hosts;
import org.apache.tomee.catalina.registration.Registrations;
import org.apache.tomee.loader.TomcatHelper;
import org.apache.tomee.webservices.CXFJAXRSFilter;

public class TomcatRsRegistry
implements RsRegistry {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_STARTUP, TomcatRsRegistry.class);
    private final Hosts hosts;
    private List<Connector> connectors;
    private final Map<Key, HttpListener> listeners = new TreeMap<Key, HttpListener>();

    public TomcatRsRegistry() {
        for (Service service : TomcatHelper.getServer().findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            this.connectors = Arrays.asList(service.findConnectors());
            break;
        }
        this.hosts = (Hosts)SystemInstance.get().getComponent(Hosts.class);
    }

    public RsRegistry.AddressInfo createRsHttpListener(String appId, String webContext, HttpListener listener, ClassLoader classLoader, String completePath, String virtualHost, String auth, String realm) {
        String path = webContext;
        if (path == null) {
            throw new NullPointerException("contextRoot is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        Context context = null;
        Host host = virtualHost == null ? this.hosts.getDefault() : this.hosts.get(virtualHost);
        if (host == null) {
            for (Host h : this.hosts) {
                context = TomcatRsRegistry.findContext((Container)h, webContext);
                if (context == null) continue;
                host = h;
                if (classLoader == null || !classLoader.equals(context.getLoader().getClassLoader())) continue;
                break;
            }
            if (host == null) {
                throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matching Host entry in the server.xml?");
            }
        } else {
            context = TomcatRsRegistry.findContext((Container)host, webContext);
        }
        if (context == null) {
            throw new IllegalStateException("Invalid context '" + webContext + "'.  Cannot find context in host " + host.getName());
        }
        CxfRsHttpListener cxfRsHttpListener = this.findCxfRsHttpListener(listener);
        String description = "tomee-jaxrs-" + listener;
        String mapping = completePath;
        if (!completePath.endsWith("/*")) {
            if (completePath.endsWith("*")) {
                mapping = completePath.substring(0, completePath.length() - 1);
            }
            mapping = mapping + "/*";
        }
        String urlPattern = TomcatRsRegistry.removeWebContext(webContext, mapping);
        cxfRsHttpListener.setUrlPattern(urlPattern.substring(0, urlPattern.length() - 1));
        FilterDef filterDef = new FilterDef();
        filterDef.setAsyncSupported("true");
        filterDef.setDescription(description);
        filterDef.setFilterName(description);
        filterDef.setDisplayName(description);
        filterDef.setFilter((Filter)new CXFJAXRSFilter(cxfRsHttpListener, context.findWelcomeFiles()));
        filterDef.setFilterClass(CXFJAXRSFilter.class.getName());
        filterDef.addInitParameter("mapping", urlPattern.substring(0, urlPattern.length() - "/*".length()));
        context.addFilterDef(filterDef);
        FilterMap filterMap = new FilterMap();
        filterMap.addURLPattern(urlPattern);
        for (DispatcherType type : DispatcherType.values()) {
            filterMap.setDispatcher(type.name());
        }
        filterMap.setFilterName(filterDef.getFilterName());
        context.addFilterMap(filterMap);
        Registrations.addFilterConfig((Context)context, (FilterDef)filterDef);
        path = TomcatRsRegistry.address(this.connectors, host.getName(), webContext);
        String key = TomcatRsRegistry.address(this.connectors, host.getName(), completePath);
        this.listeners.put(new Key(appId, key), listener);
        return new RsRegistry.AddressInfo(path, key);
    }

    private CxfRsHttpListener findCxfRsHttpListener(HttpListener listener) {
        return (CxfRsHttpListener)CxfRsHttpListener.class.cast(listener);
    }

    private static String removeWebContext(String webContext, String completePath) {
        if (webContext == null) {
            return completePath;
        }
        return completePath.substring((webContext.length() > 0 && !webContext.startsWith("/") ? 1 : 0) + webContext.length());
    }

    private static Context findContext(Container host, String webContext) {
        Container[] children;
        for (Container child : children = host.findChildren()) {
            Context context;
            if (!Context.class.isInstance(child) || !(context = (Context)child).getPath().equals(webContext)) continue;
            return context;
        }
        return null;
    }

    private static String address(Collection<Connector> connectors, String host, String path) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Connector connector : connectors) {
            URI address;
            try {
                address = new URI(connector.getScheme(), null, host, connector.getPort(), path, null, null);
            }
            catch (Exception e) {
                LOGGER.error("can't add container for path " + path, (Throwable)e);
                continue;
            }
            addresses.add(address.toString());
        }
        return HttpUtil.selectSingleAddress(addresses);
    }

    public HttpListener removeListener(String appId, String completePath) {
        String path;
        Key key;
        if (completePath != null && this.listeners.containsKey(key = new Key(appId, path = !(path = completePath).startsWith("/") && !path.startsWith("http://") && !path.startsWith("https://") ? "/" + path : completePath))) {
            return this.listeners.remove(key);
        }
        return null;
    }

    private static final class Key
    implements Comparable<Key> {
        private final String appId;
        private final String path;
        private final int hash;

        private Key(String appId, String path) {
            this.appId = appId;
            this.path = path;
            this.hash = 31 * (appId != null ? appId.hashCode() : 0) + (path != null ? path.hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)Key.class.cast(o);
            return this.appId != null ? this.appId.equals(key.appId) : key.appId == null && (this.path != null ? this.path.equals(key.path) : key.path == null);
        }

        public int hashCode() {
            return this.hash;
        }

        @Override
        public int compareTo(Key o) {
            int appCompare;
            if ((this.appId != null && !this.appId.equals(o.appId) || o.appId != null) && (appCompare = (this.appId == null ? "" : this.appId).compareTo(o.appId == null ? "" : o.appId)) != 0) {
                return appCompare;
            }
            return this.path.compareTo(o.path);
        }
    }
}

