/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader.provisining;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.loader.provisining.ArchiveResolver;
import org.apache.openejb.loader.provisining.ProvisioningResolver;
import org.apache.openejb.loader.provisining.ProvisioningResolverAware;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MavenResolver
implements ArchiveResolver,
ProvisioningResolverAware {
    private static final String REPO1 = "http://repo1.maven.org/maven2/";
    private static final String APACHE_SNAPSHOT = "https://repository.apache.org/snapshots/";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private static final AtomicReference<DocumentBuilder> BUILDER = new AtomicReference<Object>(null);
    private static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    private ProvisioningResolver resolver;

    @Override
    public String prefix() {
        return "mvn";
    }

    @Override
    public InputStream resolve(String url) {
        try {
            String sanitized = this.sanitize(url);
            String repo1Url = this.quickMvnUrl(sanitized);
            return this.resolveStream(repo1Url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String sanitize(String url) {
        int sep = url.indexOf(33) + 1;
        String value = url.substring(this.prefix().length() + 1);
        return value.substring(0, sep) + value.substring(sep).replace(":", "/");
    }

    @Override
    public String name(String rawLocation) {
        try {
            String s = this.mvnArtifactPath(this.sanitize(rawLocation), "");
            return s.substring(s.lastIndexOf(47) + 1);
        }
        catch (MalformedURLException e) {
            return rawLocation + ".jar";
        }
    }

    private InputStream resolveStream(String repo1Url) throws MalformedURLException {
        if (this.resolver != null) {
            return this.resolver.resolveStream(repo1Url);
        }
        return Objects.requireNonNull(SystemInstance.get().getComponent(ProvisioningResolver.class)).resolveStream(repo1Url);
    }

    public String quickMvnUrl(String raw) throws MalformedURLException {
        String toParse;
        String base = raw.contains(SNAPSHOT_SUFFIX) && raw.contains("apache") ? System.getProperty("openejb.deployer.snapshot.repository", APACHE_SNAPSHOT) : System.getProperty("openejb.deployer.repository", REPO1);
        StringBuilder builder = new StringBuilder();
        if (!raw.contains("!")) {
            File file = new File(MavenResolver.m2Home() + this.mvnArtifactPath(raw, null));
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            toParse = raw;
        } else {
            int repoIdx = raw.lastIndexOf(33);
            toParse = raw.substring(repoIdx + 1);
        }
        builder.append(this.mvnArtifactPath(toParse, base));
        return builder.toString();
    }

    private static String m2Home() {
        Properties properties = SystemInstance.isInitialized() ? SystemInstance.get().getProperties() : System.getProperties();
        String home = "";
        File f = new File(properties.getProperty("openejb.m2.settings", System.getProperty("user.home") + "/.m2/settings.xml"));
        if (f.exists()) {
            try {
                DocumentBuilder builder = BUILDER.get();
                if (null == builder) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    builder = factory.newDocumentBuilder();
                    BUILDER.set(builder);
                }
                Document document = builder.parse(f);
                XPathFactory xpf = XPathFactory.newInstance();
                XPath xp = xpf.newXPath();
                home = xp.evaluate("//settings/localRepository/text()", document.getDocumentElement());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (home.isEmpty() && (f = new File(properties.getProperty("openejb.m2.home", System.getProperty("user.home") + "/.m2/repository/"))).exists()) {
            home = f.getAbsolutePath();
        }
        return home.endsWith("/") ? home : home + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String mvnArtifactPath(String toParse, String snapshotBase) throws MalformedURLException {
        String artifactVersion;
        String base;
        String version;
        String artifact;
        String group;
        String[] segments;
        block19: {
            block20: {
                segments = toParse.split("/");
                if (segments.length < 3) {
                    throw new MalformedURLException("Invalid path. " + toParse);
                }
                group = segments[0];
                if (group.trim().isEmpty()) {
                    throw new MalformedURLException("Invalid groupId. " + toParse);
                }
                artifact = segments[1];
                if (artifact.trim().isEmpty()) {
                    throw new MalformedURLException("Invalid artifactId. " + toParse);
                }
                version = segments[2];
                if (version.trim().isEmpty()) {
                    throw new MalformedURLException("Invalid artifactId. " + toParse);
                }
                String string = snapshotBase == null || snapshotBase.isEmpty() ? "" : (base = snapshotBase + (!snapshotBase.endsWith("/") ? "/" : ""));
                if (("LATEST".equals(version) || "LATEST-SNAPSHOT".equals(version)) && base.startsWith("http")) {
                    String meta = base + group.replace('.', '/') + "/" + artifact + "/maven-metadata.xml";
                    URL url = new URL(meta);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    InputStream is = null;
                    try {
                        is = this.resolveStream(url.toExternalForm());
                        if (is == null) {
                            throw new IllegalArgumentException("can't resolve " + url);
                        }
                        IO.copy(is, (OutputStream)out);
                        version = MavenResolver.extractRealVersion(version, out);
                    }
                    catch (Exception exception) {
                        IO.close(is);
                        catch (Throwable throwable) {
                            IO.close(is);
                            throw throwable;
                        }
                    }
                    IO.close(is);
                }
                if (!version.endsWith(SNAPSHOT_SUFFIX) || !base.startsWith("http")) break block20;
                String meta = base + group.replace('.', '/') + "/" + artifact + "/" + version + "/maven-metadata.xml";
                URL url = new URL(meta);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                InputStream is = null;
                try {
                    is = this.resolveStream(url.toExternalForm());
                    if (is == null) {
                        throw new IllegalArgumentException("can't resolve " + url);
                    }
                    IO.copy(is, (OutputStream)out);
                    artifactVersion = MavenResolver.extractLastSnapshotVersion(version, new ByteArrayInputStream(out.toByteArray()));
                }
                catch (Exception e) {
                    try {
                        artifactVersion = version;
                    }
                    catch (Throwable throwable) {
                        IO.close(is);
                        throw throwable;
                    }
                    IO.close(is);
                    break block19;
                }
                IO.close(is);
                break block19;
            }
            artifactVersion = version;
        }
        String type = "jar";
        if (segments.length >= 4 && segments[3].trim().length() > 0) {
            type = segments[3];
        }
        String fullClassifier = null;
        if (segments.length >= 5 && segments[4].trim().length() > 0) {
            fullClassifier = "-" + segments[4];
        }
        StringBuilder builder = new StringBuilder(base);
        builder.append(group.replace('.', '/')).append("/");
        builder.append(artifact).append("/");
        builder.append(version).append("/");
        builder.append(artifact).append("-").append(artifactVersion);
        if (fullClassifier != null) {
            builder.append(fullClassifier);
        }
        return builder.append(".").append(type).toString();
    }

    private static String extractRealVersion(String version, ByteArrayOutputStream out) {
        QuickMvnMetadataParser handler = new QuickMvnMetadataParser();
        try {
            SAXParser parser = FACTORY.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(out.toByteArray()), (DefaultHandler)handler);
            if (!version.endsWith(SNAPSHOT_SUFFIX) && handler.release != null) {
                version = handler.release.toString();
            } else if (handler.latest != null) {
                version = handler.latest.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    private static String extractLastSnapshotVersion(String defaultVersion, InputStream metadata) {
        QuickMvnMetadataParser handler = new QuickMvnMetadataParser();
        try {
            SAXParser parser = FACTORY.newSAXParser();
            parser.parse(metadata, (DefaultHandler)handler);
            if (handler.timestamp != null && handler.buildNumber != null) {
                return defaultVersion.substring(0, defaultVersion.length() - SNAPSHOT_SUFFIX.length()) + "-" + handler.timestamp + "-" + handler.buildNumber;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultVersion;
    }

    @Override
    public void setResolver(ProvisioningResolver resolver) {
        this.resolver = resolver;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static {
        FACTORY.setNamespaceAware(false);
        FACTORY.setValidating(false);
    }

    private static class QuickMvnMetadataParser
    extends DefaultHandler {
        private StringBuilder timestamp;
        private StringBuilder buildNumber;
        private StringBuilder latest;
        private StringBuilder release;
        private StringBuilder text;

        private QuickMvnMetadataParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("timestamp".equalsIgnoreCase(qName)) {
                this.text = this.timestamp = new StringBuilder();
            } else if ("buildNumber".equalsIgnoreCase(qName)) {
                this.text = this.buildNumber = new StringBuilder();
            } else if ("latest".equalsIgnoreCase(qName)) {
                this.text = this.latest = new StringBuilder();
            } else if ("release".equalsIgnoreCase(qName)) {
                this.text = this.release = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.text != null) {
                this.text.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.text = null;
        }
    }
}

