/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import javax.ejb.EJBHome;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateful.BasicStatefulObject;
import org.apache.openejb.test.stateful.BasicStatefulTestClient;

public class StatefulEjbMetaDataTests
extends BasicStatefulTestClient {
    public StatefulEjbMetaDataTests() {
        super("EJBMetaData.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateful/BasicStatefulHome");
        this.ejbHome = (BasicStatefulHome)obj;
        this.ejbMetaData = this.ejbHome.getEJBMetaData();
    }

    public void test01_getEJBHome() {
        try {
            EJBHome home = this.ejbMetaData.getEJBHome();
            StatefulEjbMetaDataTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            StatefulEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_getHomeInterfaceClass() {
        try {
            Class clazz = this.ejbMetaData.getHomeInterfaceClass();
            StatefulEjbMetaDataTests.assertNotNull((String)"The Home Interface class is null", (Object)clazz);
            StatefulEjbMetaDataTests.assertEquals((Object)clazz, BasicStatefulHome.class);
        }
        catch (Exception e) {
            StatefulEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_getPrimaryKeyClass() {
        try {
            Class clazz = this.ejbMetaData.getPrimaryKeyClass();
            StatefulEjbMetaDataTests.assertNull((String)"Should not return a primary key.  Method should throw an java.lang.RuntimeException", (Object)clazz);
        }
        catch (UnsupportedOperationException e) {
            StatefulEjbMetaDataTests.assertTrue((boolean)true);
            return;
        }
        catch (Exception e) {
            StatefulEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatefulEjbMetaDataTests.assertTrue((String)"Method should throw an java.lang.RuntimeException", (boolean)false);
    }

    public void test04_getRemoteInterfaceClass() {
        try {
            Class clazz = this.ejbMetaData.getRemoteInterfaceClass();
            StatefulEjbMetaDataTests.assertNotNull((String)"The Remote Interface class is null", (Object)clazz);
            StatefulEjbMetaDataTests.assertEquals((Object)clazz, BasicStatefulObject.class);
        }
        catch (Exception e) {
            StatefulEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_isSession() {
        try {
            StatefulEjbMetaDataTests.assertTrue((String)"EJBMetaData says this is not a session bean", (boolean)this.ejbMetaData.isSession());
        }
        catch (Exception e) {
            StatefulEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_isStatelessSession() {
        try {
            StatefulEjbMetaDataTests.assertTrue((String)"EJBMetaData says this is a stateless session bean", (!this.ejbMetaData.isStatelessSession() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            StatefulEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

