/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmr;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import org.apache.openejb.test.entity.cmr.AbstractCMRTest;
import org.apache.openejb.test.entity.cmr.onetomany.ArtistLocal;
import org.apache.openejb.test.entity.cmr.onetomany.ArtistLocalHome;
import org.apache.openejb.test.entity.cmr.onetomany.ArtistPk;
import org.apache.openejb.test.entity.cmr.onetomany.SongLocal;
import org.apache.openejb.test.entity.cmr.onetomany.SongLocalHome;
import org.apache.openejb.test.entity.cmr.onetomany.SongPk;

public class OneToManyComplexPkTests
extends AbstractCMRTest {
    private ArtistLocalHome artistLocalHome;
    private SongLocalHome songLocalHome;

    public OneToManyComplexPkTests() {
        super("OneToManyComplex.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.artistLocalHome = (ArtistLocalHome)this.initialContext.lookup("client/tests/entity/cmr/oneToMany/ComplexArtistLocal");
        this.songLocalHome = (SongLocalHome)this.initialContext.lookup("client/tests/entity/cmr/oneToMany/ComplexSongLocal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test00_AGetBExistingAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            Set bSet = artist.getPerformed();
            OneToManyComplexPkTests.assertEquals((long)2L, (long)bSet.size());
            for (Object value : bSet) {
                SongLocal song = (SongLocal)value;
                if (song.getId().equals(11)) {
                    OneToManyComplexPkTests.assertEquals((Object)"value11", (Object)song.getName());
                    continue;
                }
                if (song.getId().equals(22)) {
                    OneToManyComplexPkTests.assertEquals((Object)"value22", (Object)song.getName());
                    continue;
                }
                OneToManyComplexPkTests.fail();
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    public void test01_BGetAExistingAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            SongLocal song = this.findSong(11);
            ArtistLocal artist = song.getPerformer();
            OneToManyComplexPkTests.assertNotNull((Object)artist);
            OneToManyComplexPkTests.assertEquals((Object)new Integer(1), (Object)artist.getId());
            OneToManyComplexPkTests.assertEquals((Object)"value1", (Object)artist.getName());
            song = this.findSong(22);
            artist = song.getPerformer();
            OneToManyComplexPkTests.assertNotNull((Object)artist);
            OneToManyComplexPkTests.assertEquals((Object)new Integer(1), (Object)artist.getId());
            OneToManyComplexPkTests.assertEquals((Object)"value1", (Object)artist.getName());
        }
        finally {
            this.completeTransaction();
        }
    }

    public void test02_ASetBDropExisting() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            artist.setPerformed(new HashSet());
        }
        finally {
            this.completeTransaction();
        }
        this.assertUnlinked(1);
    }

    public void test03_BSetADropExisting() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            SongLocal song = this.findSong(11);
            song.setPerformer(null);
            song = this.findSong(22);
            song.setPerformer(null);
        }
        finally {
            this.completeTransaction();
        }
        this.assertUnlinked(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test04_ASetBNewAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(2);
            SongLocal song = this.findSong(22);
            HashSet<SongLocal> songSets = new HashSet<SongLocal>();
            songSets.add(song);
            artist.setPerformed(songSets);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 22);
    }

    public void test05_BSetANewAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(2);
            SongLocal song = this.findSong(22);
            song.setPerformer(artist);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 22);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test06_ASetBExistingBNewA() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(2);
            SongLocal song = this.findSong(11);
            Set songSets = artist.getPerformed();
            songSets.add(song);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 11);
    }

    public void test07_BSetAExistingBNewA() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(2);
            SongLocal song = this.findSong(11);
            song.setPerformer(artist);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test08_ASetBExistingANewB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            SongLocal song = this.createSong(33);
            Set songSets = artist.getPerformed();
            songSets.add(song);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(1, 11, 22, 33);
    }

    public void test09_BSetAExistingANewB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            SongLocal song = this.createSong(33);
            song.setPerformer(artist);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(1, 11, 22, 33);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test10_RemoveRelationships() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            SongLocal song = this.findSong(11);
            ArtistLocal artist = song.getPerformer();
            Set songs = artist.getPerformed();
            OneToManyComplexPkTests.assertTrue((boolean)songs.contains(song));
            song.remove();
            OneToManyComplexPkTests.assertFalse((boolean)songs.contains(song));
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(1, 22);
        this.assertUnlinked(2);
    }

    public void TODO_testCMPMappedToForeignKeyColumn() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            SongLocal song = this.findSong(11);
            Integer field3 = song.getBpm();
            OneToManyComplexPkTests.assertEquals((Object)song.getPerformer().getPrimaryKey(), (Object)field3);
        }
        finally {
            this.completeTransaction();
        }
    }

    public void TODO_testSetCMPMappedToForeignKeyColumn() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            SongLocal song = this.findSong(11);
            song.setBpm(Integer.valueOf(2));
            ArtistLocal artist = song.getPerformer();
            OneToManyComplexPkTests.assertEquals((Object)new Integer(2), (Object)artist.getId());
            OneToManyComplexPkTests.assertEquals((Object)"value2", (Object)artist.getName());
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test11_Delete() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            artist.setPerformed(new HashSet());
            Set songs = artist.getComposed();
            HashSet bsCopies = new HashSet(songs);
            OneToManyComplexPkTests.assertFalse((boolean)songs.isEmpty());
            artist.remove();
            OneToManyComplexPkTests.assertTrue((boolean)songs.isEmpty());
            for (SongLocal songLocal : bsCopies) {
                OneToManyComplexPkTests.assertNull((Object)songLocal.getComposer());
            }
        }
        finally {
            this.completeTransaction();
        }
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM ComplexSong");
        OneToManyComplexPkTests.assertTrue((boolean)rs.next());
        OneToManyComplexPkTests.assertEquals((long)2L, (long)rs.getInt(1));
        rs.close();
        s.close();
        c.close();
    }

    public void test12_CascadeDelete() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(1);
            Set songs = artist.getPerformed();
            OneToManyComplexPkTests.assertFalse((boolean)songs.isEmpty());
            artist.remove();
            OneToManyComplexPkTests.assertTrue((boolean)songs.isEmpty());
        }
        finally {
            this.completeTransaction();
        }
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM ComplexSong");
        OneToManyComplexPkTests.assertTrue((boolean)rs.next());
        OneToManyComplexPkTests.assertEquals((long)0L, (long)rs.getInt(1));
        rs.close();
        s.close();
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIllegalCmrCollectionArgument() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(new Integer(1));
            Set songs = artist.getComposed();
            try {
                songs.add(new Object());
                OneToManyComplexPkTests.fail((String)"expected games.add(new Object()) to throw an IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                songs.addAll(Arrays.asList(new Object()));
                OneToManyComplexPkTests.fail((String)"expected games.addAll(Arrays.asList(new Object())) to throw an IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyCmrCollectionOusideTx() throws Exception {
        Set songs;
        SongLocal newSong;
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(new Integer(1));
            newSong = this.createSong(new Integer(33));
            songs = artist.getComposed();
        }
        finally {
            this.completeTransaction();
        }
        OneToManyComplexPkTests.assertFalse((boolean)songs.isEmpty());
        OneToManyComplexPkTests.assertEquals((long)2L, (long)songs.size());
        for (SongLocal song : songs) {
            if (song.getId().equals(new Integer(11))) {
                OneToManyComplexPkTests.assertEquals((Object)"value11", (Object)song.getName());
                continue;
            }
            if (song.getId().equals(new Integer(22))) {
                OneToManyComplexPkTests.assertEquals((Object)"value22", (Object)song.getName());
                continue;
            }
            OneToManyComplexPkTests.fail();
        }
        try {
            songs.add(newSong);
            OneToManyComplexPkTests.fail((String)"expected songs.add(newSong) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        try {
            songs.addAll(Arrays.asList(newSong));
            OneToManyComplexPkTests.fail((String)"expected songs.addAll(Arrays.asList(newSong)) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        try {
            songs.remove(newSong);
            OneToManyComplexPkTests.fail((String)"expected songs.remove(newSong) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        try {
            songs.removeAll(Arrays.asList(newSong));
            OneToManyComplexPkTests.fail((String)"expected songs.removeAll(Arrays.asList(newSong)) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        Iterator iterator = songs.iterator();
        try {
            iterator.remove();
            OneToManyComplexPkTests.fail((String)"expected iterator.remove() to throw an ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyCmrCollectionInNewTx() throws Exception {
        Set songs;
        SongLocal newSong;
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(new Integer(1));
            newSong = this.createSong(new Integer(33));
            songs = artist.getComposed();
        }
        finally {
            this.completeTransaction();
        }
        this.beginTransaction();
        try {
            OneToManyComplexPkTests.assertFalse((boolean)songs.isEmpty());
            OneToManyComplexPkTests.assertEquals((long)2L, (long)songs.size());
            for (SongLocal song : songs) {
                if (song.getId().equals(new Integer(11))) {
                    OneToManyComplexPkTests.assertEquals((Object)"value11", (Object)song.getName());
                    continue;
                }
                if (song.getId().equals(new Integer(22))) {
                    OneToManyComplexPkTests.assertEquals((Object)"value22", (Object)song.getName());
                    continue;
                }
                OneToManyComplexPkTests.fail();
            }
            try {
                songs.add(newSong);
                OneToManyComplexPkTests.fail((String)"expected songs.add(newSong) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            try {
                songs.addAll(Arrays.asList(newSong));
                OneToManyComplexPkTests.fail((String)"expected songs.addAll(Arrays.asList(newSong)) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            try {
                songs.remove(newSong);
                OneToManyComplexPkTests.fail((String)"expected songs.remove(newSong) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            try {
                songs.removeAll(Arrays.asList(newSong));
                OneToManyComplexPkTests.fail((String)"expected songs.removeAll(Arrays.asList(newSong)) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            Iterator iterator = songs.iterator();
            try {
                iterator.remove();
                OneToManyComplexPkTests.fail((String)"expected iterator.remove() to throw an ConcurrentModificationException");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIteratorConcurrentModification() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(new Integer(1));
            SongLocal song = this.findSong(new Integer(11));
            Set songs = artist.getComposed();
            OneToManyComplexPkTests.assertFalse((boolean)songs.isEmpty());
            OneToManyComplexPkTests.assertEquals((long)2L, (long)songs.size());
            Iterator iterator = songs.iterator();
            songs.remove(song);
            OneToManyComplexPkTests.assertEquals((long)1L, (long)songs.size());
            try {
                iterator.next();
                OneToManyComplexPkTests.fail((String)"expected iterator.next() to throw an ConcurrentModificationException");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIteratorAndRemove() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            ArtistLocal artist = this.findArtist(new Integer(1));
            SongLocal song = this.findSong(new Integer(11));
            Set games = artist.getComposed();
            OneToManyComplexPkTests.assertFalse((boolean)games.isEmpty());
            OneToManyComplexPkTests.assertEquals((long)2L, (long)games.size());
            Iterator iterator = games.iterator();
            OneToManyComplexPkTests.assertTrue((boolean)games.contains(song));
            artist.remove();
            OneToManyComplexPkTests.assertFalse((boolean)games.contains(song));
            OneToManyComplexPkTests.assertEquals((long)0L, (long)games.size());
            try {
                iterator.next();
                OneToManyComplexPkTests.fail((String)"expected iterator.next() to throw an ConcurrentModificationException");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    private ArtistLocal createArtist(int artistId) throws CreateException {
        ArtistLocal artist = this.artistLocalHome.create(new ArtistPk(Integer.valueOf(artistId), "value" + artistId));
        return artist;
    }

    private ArtistLocal findArtist(int artistId) throws FinderException {
        return this.artistLocalHome.findByPrimaryKey(new ArtistPk(Integer.valueOf(artistId), "value" + artistId));
    }

    private SongLocal createSong(int songId) throws CreateException {
        SongLocal song = this.songLocalHome.create(new SongPk(Integer.valueOf(songId), "value" + songId));
        return song;
    }

    private SongLocal findSong(int songId) throws FinderException {
        return this.songLocalHome.findByPrimaryKey(new SongPk(Integer.valueOf(songId), "value" + songId));
    }

    private void assertLinked(int artistId, int ... songIds) throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT name FROM ComplexArtist WHERE id = " + artistId);
        OneToManyComplexPkTests.assertTrue((boolean)rs.next());
        OneToManyComplexPkTests.assertEquals((Object)("value" + artistId), (Object)rs.getString("name"));
        OneToManyComplexPkTests.close(rs);
        rs = s.executeQuery("SELECT COUNT(*) FROM ComplexSong WHERE performer_id = 1");
        OneToManyComplexPkTests.assertTrue((boolean)rs.next());
        OneToManyComplexPkTests.assertEquals((long)songIds.length, (long)rs.getInt(1));
        rs.close();
        for (int songId : songIds) {
            rs = s.executeQuery("SELECT name, performer_id FROM ComplexSong WHERE id = " + songId);
            OneToManyComplexPkTests.assertTrue((boolean)rs.next());
            OneToManyComplexPkTests.assertEquals((Object)("value" + songId), (Object)rs.getString("name"));
            OneToManyComplexPkTests.assertEquals((long)artistId, (long)rs.getInt("performer_id"));
            OneToManyComplexPkTests.close(rs);
        }
        OneToManyComplexPkTests.close(s);
        OneToManyComplexPkTests.close(c);
    }

    private void assertUnlinked(int aPk) throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM ComplexSong WHERE performer_id = " + aPk);
        OneToManyComplexPkTests.assertTrue((boolean)rs.next());
        OneToManyComplexPkTests.assertEquals((long)0L, (long)rs.getInt(1));
        OneToManyComplexPkTests.close(rs);
        OneToManyComplexPkTests.close(s);
        OneToManyComplexPkTests.close(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDB() throws Exception {
        Connection connection = this.ds.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            try {
                statement.execute("DELETE FROM ComplexArtist");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement.execute("DELETE FROM ComplexSong");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            OneToManyComplexPkTests.close(statement);
            OneToManyComplexPkTests.close(connection);
        }
        ArtistLocal artist1 = this.createArtist(1);
        this.createArtist(2);
        SongLocal song1 = this.createSong(11);
        SongLocal song2 = this.createSong(22);
        song1.setPerformer(artist1);
        song2.setPerformer(artist1);
        song1.setComposer(artist1);
        song2.setComposer(artist1);
    }

    protected void dump() throws SQLException {
        OneToManyComplexPkTests.dumpTable(this.ds, "ComplexArtist");
        OneToManyComplexPkTests.dumpTable(this.ds, "ComplexSong");
    }
}

