/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.MarshalledObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import org.apache.openejb.test.entity.cmp.UnknownCmpHome;
import org.apache.openejb.test.entity.cmp2.UnknownCmp2TestClient;

public class Unknown2HandleTests
extends UnknownCmp2TestClient {
    public Unknown2HandleTests() {
        super("Handle.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp2/UnknownCmpHome");
        this.ejbHome = (UnknownCmpHome)obj;
        this.ejbObject = this.ejbHome.createObject("Fifth Bean");
        this.ejbHandle = this.ejbObject.getHandle();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.ejbObject != null) {
            this.ejbObject.remove();
        }
        super.tearDown();
    }

    public void test01_getEJBObject() {
        try {
            EJBObject object = this.ejbHandle.getEJBObject();
            Unknown2HandleTests.assertNotNull((String)"The EJBObject is null", (Object)object);
        }
        catch (Exception e) {
            Unknown2HandleTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void Xtest02_copyHandleByMarshalledObject() {
        try {
            MarshalledObject<Handle> obj = new MarshalledObject<Handle>(this.ejbHandle);
            Handle copy = obj.get();
            EJBObject object = copy.getEJBObject();
            Unknown2HandleTests.assertNotNull((String)"The EJBObject is null", (Object)object);
            Unknown2HandleTests.assertTrue((String)"EJBObjects are not identical", (boolean)object.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            Unknown2HandleTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void Xtest03_copyHandleBySerialize() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.ejbHandle);
            oos.flush();
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Handle copy = (Handle)ois.readObject();
            EJBObject object = copy.getEJBObject();
            Unknown2HandleTests.assertNotNull((String)"The EJBObject is null", (Object)object);
            Unknown2HandleTests.assertTrue((String)"EJBObjects are not identical", (boolean)object.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            Unknown2HandleTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_EJBHome_remove() {
        try {
            this.ejbHome.remove(this.ejbHandle);
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                Unknown2HandleTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception e) {
                Unknown2HandleTests.assertTrue((boolean)true);
            }
        }
        catch (Exception e) {
            Unknown2HandleTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.ejbObject = null;
        }
    }
}

