/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp2;

import org.apache.openejb.test.entity.cmp.BasicCmpHome;
import org.apache.openejb.test.entity.cmp.BasicCmpObject;
import org.apache.openejb.test.entity.cmp2.BasicCmp2TestClient;
import org.apache.openejb.test.object.OperationsPolicy;

public class Cmp2AllowedOperationsTests
extends BasicCmp2TestClient {
    public Cmp2AllowedOperationsTests() {
        super("AllowedOperations.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp2/allowed_operations/EntityHome");
        this.ejbHome = (BasicCmpHome)obj;
        this.ejbObject = this.ejbHome.createObject("Fourth Bean");
        this.ejbHandle = this.ejbObject.getHandle();
        this.doScenario();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.ejbObject.remove();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.tearDown();
    }

    private void doScenario() throws Exception {
        this.ejbObject.businessMethod("Reverse Me");
        this.ejbHome.sum(1, 2);
        this.ejbObject = (BasicCmpObject)this.ejbHandle.getEJBObject();
        this.ejbHome.findByPrimaryKey((Integer)this.ejbObject.getPrimaryKey());
        this.ejbHome.remove(this.ejbObject.getPrimaryKey());
        this.ejbObject = this.ejbHome.createObject("Fourth Bean");
        this.ejbHome.findEmptyCollection();
    }

    public void test01_setEntityContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("setEntityContext");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void TODO_test02_unsetEntityContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("unsetEntityContext");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(2);
            policy.allow(3);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbCreate");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_ejbPostCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(2);
            policy.allow(6);
            policy.allow(7);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbPostCreate");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(2);
            policy.allow(6);
            policy.allow(7);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbRemove");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test08_ejbHome() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(2);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbHome");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test10_ejbActivate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(7);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbActivate");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void TODO_test11_ejbPassivate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(7);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbPassivate");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test12_ejbLoad() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(2);
            policy.allow(6);
            policy.allow(7);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbLoad");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test13_ejbStore() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(2);
            policy.allow(6);
            policy.allow(7);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbStore");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test14_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(2);
            policy.allow(6);
            policy.allow(7);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("businessMethod");
            Cmp2AllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            Cmp2AllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            Cmp2AllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

