/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import org.apache.openejb.test.entity.cmp.CmpTestClient;
import org.apache.openejb.test.entity.cmp.EncCmpHome;
import org.apache.openejb.test.entity.cmp.EncCmpObject;
import org.apache.openejb.test.entity.cmp.RmiIiopCmpHome;
import org.apache.openejb.test.entity.cmp.RmiIiopCmpObject;
import org.apache.openejb.test.object.ObjectGraph;

public class CmpRmiIiopTests
extends CmpTestClient {
    protected RmiIiopCmpHome ejbHome;
    protected RmiIiopCmpObject ejbObject;

    public CmpRmiIiopTests() {
        super("RMI_IIOP.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp/RMI-over-IIOP/EJBHome");
        this.ejbHome = (RmiIiopCmpHome)obj;
        this.ejbObject = this.ejbHome.create("RMI-IIOP TestBean");
    }

    public void test01_returnStringObject() {
        try {
            String expected = new String("1");
            String actual = this.ejbObject.returnStringObject(expected);
            CmpRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_returnStringObjectArray() {
        try {
            String[] expected = new String[]{"1", "2", "3"};
            String[] actual = this.ejbObject.returnStringObjectArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_returnCharacterObject() {
        try {
            Character expected = new Character('1');
            Character actual = this.ejbObject.returnCharacterObject(expected);
            CmpRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_returnCharacterPrimitive() {
        try {
            int expected = 49;
            char actual = this.ejbObject.returnCharacterPrimitive('1');
            CmpRmiIiopTests.assertEquals((long)49L, (long)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_returnCharacterObjectArray() {
        try {
            Character[] expected = new Character[]{new Character('1'), new Character('2'), new Character('3')};
            Character[] actual = this.ejbObject.returnCharacterObjectArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_returnCharacterPrimitiveArray() {
        try {
            char[] expected = new char[]{'1', '2', '3'};
            char[] actual = this.ejbObject.returnCharacterPrimitiveArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (long)expected[i], (long)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test07_returnBooleanObject() {
        try {
            Boolean expected = Boolean.TRUE;
            Boolean actual = this.ejbObject.returnBooleanObject(expected);
            CmpRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test08_returnBooleanPrimitive() {
        try {
            boolean expected = true;
            boolean actual = this.ejbObject.returnBooleanPrimitive(true);
            CmpRmiIiopTests.assertEquals((Object)"true", (Object)("" + actual));
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test09_returnBooleanObjectArray() {
        try {
            Boolean[] expected = new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE};
            Boolean[] actual = this.ejbObject.returnBooleanObjectArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test10_returnBooleanPrimitiveArray() {
        try {
            boolean[] expected = new boolean[]{false, true, true};
            boolean[] actual = this.ejbObject.returnBooleanPrimitiveArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test11_returnByteObject() {
        try {
            Byte expected = new Byte("1");
            Byte actual = this.ejbObject.returnByteObject(expected);
            CmpRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test12_returnBytePrimitive() {
        try {
            boolean expected = true;
            byte actual = this.ejbObject.returnBytePrimitive((byte)1);
            CmpRmiIiopTests.assertEquals((long)1L, (long)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test13_returnByteObjectArray() {
        try {
            Byte[] expected = new Byte[]{new Byte("1"), new Byte("2"), new Byte("3")};
            Byte[] actual = this.ejbObject.returnByteObjectArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test14_returnBytePrimitiveArray() {
        try {
            byte[] expected = new byte[]{1, 2, 3};
            byte[] actual = this.ejbObject.returnBytePrimitiveArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (long)expected[i], (long)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test15_returnShortObject() {
        try {
            Short expected = new Short("1");
            Short actual = this.ejbObject.returnShortObject(expected);
            CmpRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test16_returnShortPrimitive() {
        try {
            boolean expected = true;
            short actual = this.ejbObject.returnShortPrimitive((short)1);
            CmpRmiIiopTests.assertEquals((long)1L, (long)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test17_returnShortObjectArray() {
        try {
            Short[] expected = new Short[]{new Short("1"), new Short("2"), new Short("3")};
            Short[] actual = this.ejbObject.returnShortObjectArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test18_returnShortPrimitiveArray() {
        try {
            short[] expected = new short[]{1, 2, 3};
            short[] actual = this.ejbObject.returnShortPrimitiveArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (long)expected[i], (long)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test19_returnIntegerObject() {
        try {
            Integer expected = new Integer(1);
            Integer actual = this.ejbObject.returnIntegerObject(expected);
            CmpRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test20_returnIntegerPrimitive() {
        try {
            boolean expected = true;
            int actual = this.ejbObject.returnIntegerPrimitive(1);
            CmpRmiIiopTests.assertEquals((long)1L, (long)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test21_returnIntegerObjectArray() {
        try {
            Integer[] expected = new Integer[]{new Integer(1), new Integer(2), new Integer(3)};
            Integer[] actual = this.ejbObject.returnIntegerObjectArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test22_returnIntegerPrimitiveArray() {
        try {
            int[] expected = new int[]{1, 2, 3};
            int[] actual = this.ejbObject.returnIntegerPrimitiveArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (long)expected[i], (long)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test23_returnLongObject() {
        try {
            Long expected = new Long("1");
            Long actual = this.ejbObject.returnLongObject(expected);
            CmpRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test24_returnLongPrimitive() {
        try {
            long expected = 1L;
            long actual = this.ejbObject.returnLongPrimitive(1L);
            CmpRmiIiopTests.assertEquals((long)1L, (long)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test25_returnLongObjectArray() {
        try {
            Long[] expected = new Long[]{new Long("1"), new Long("2"), new Long("3")};
            Long[] actual = this.ejbObject.returnLongObjectArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test26_returnLongPrimitiveArray() {
        try {
            long[] expected = new long[]{1L, 2L, 3L};
            long[] actual = this.ejbObject.returnLongPrimitiveArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (long)expected[i], (long)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test27_returnFloatObject() {
        try {
            Float expected = new Float("1.3");
            Float actual = this.ejbObject.returnFloatObject(expected);
            CmpRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test28_returnFloatPrimitive() {
        try {
            float expected = 1.2f;
            float actual = this.ejbObject.returnFloatPrimitive(1.2f);
            CmpRmiIiopTests.assertEquals((double)1.2f, (double)actual, (double)0.0);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test29_returnFloatObjectArray() {
        try {
            Float[] expected = new Float[]{new Float("1.1"), new Float("2.2"), new Float("3.3")};
            Float[] actual = this.ejbObject.returnFloatObjectArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test30_returnFloatPrimitiveArray() {
        try {
            float[] expected = new float[]{1.2f, 2.3f, 3.4f};
            float[] actual = this.ejbObject.returnFloatPrimitiveArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (double)expected[i], (double)actual[i], (double)0.0);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test31_returnDoubleObject() {
        try {
            Double expected = new Double("1.1");
            Double actual = this.ejbObject.returnDoubleObject(expected);
            CmpRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test32_returnDoublePrimitive() {
        try {
            double expected = 1.2;
            double actual = this.ejbObject.returnDoublePrimitive(1.2);
            CmpRmiIiopTests.assertEquals((double)1.2, (double)actual, (double)0.0);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test33_returnDoubleObjectArray() {
        try {
            Double[] expected = new Double[]{new Double("1.3"), new Double("2.4"), new Double("3.5")};
            Double[] actual = this.ejbObject.returnDoubleObjectArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test34_returnDoublePrimitiveArray() {
        try {
            double[] expected = new double[]{1.4, 2.5, 3.6};
            double[] actual = this.ejbObject.returnDoublePrimitiveArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (double)expected[i], (double)actual[i], (double)0.0);
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test35_returnEJBHome() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome expected = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)expected);
            EncCmpHome actual = (EncCmpHome)this.ejbObject.returnEJBHome((EJBHome)expected);
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test36_returnEJBHome2() {
        try {
            EncCmpHome actual = (EncCmpHome)this.ejbObject.returnEJBHome();
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test37_returnNestedEJBHome() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome expected = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)expected);
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            CmpRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncCmpHome actual = (EncCmpHome)graph.getObject();
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test38_returnNestedEJBHome2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedEJBHome();
            CmpRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncCmpHome actual = (EncCmpHome)graph.getObject();
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test39_returnEJBHomeArray() {
        try {
            EncCmpHome[] expected = new EncCmpHome[3];
            for (int i = 0; i < expected.length; ++i) {
                Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
                expected[i] = (EncCmpHome)obj;
                CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)expected[i]);
            }
            EJBHome[] actual = this.ejbObject.returnEJBHomeArray((EJBHome[])expected);
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test40_returnEJBObject() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome home = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncCmpObject expected = home.create("test_40 CmpBean");
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)expected);
            EncCmpObject actual = (EncCmpObject)this.ejbObject.returnEJBObject((EJBObject)expected);
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject returned is null", (Object)actual);
            CmpRmiIiopTests.assertTrue((String)"The EJBObejcts are not identical", (boolean)expected.isIdentical((EJBObject)actual));
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test41_returnEJBObject2() {
        try {
            EncCmpObject actual = (EncCmpObject)this.ejbObject.returnEJBObject();
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject returned is null", (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test42_returnNestedEJBObject() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome home = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncCmpObject expected = home.create("test_42 CmpBean");
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)expected);
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            CmpRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncCmpObject actual = (EncCmpObject)graph.getObject();
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject returned is null", (Object)actual);
            CmpRmiIiopTests.assertTrue((String)"The EJBObejcts are not identical", (boolean)expected.isIdentical((EJBObject)actual));
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test43_returnNestedEJBObject2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedEJBObject();
            CmpRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncCmpObject actual = (EncCmpObject)graph.getObject();
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test44_returnEJBObjectArray() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome home = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncCmpObject[] expected = new EncCmpObject[3];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = home.create("test_44 CmpBean");
                CmpRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)expected[i]);
            }
            EJBObject[] actual = this.ejbObject.returnEJBObjectArray((EJBObject[])expected);
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertTrue((String)"The EJBObejcts are not identical", (boolean)expected[i].isIdentical(actual[i]));
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test45_returnEJBMetaData() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome home = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EJBMetaData expected = home.getEJBMetaData();
            CmpRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)expected);
            EJBMetaData actual = this.ejbObject.returnEJBMetaData(expected);
            CmpRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((Object)expected.getHomeInterfaceClass(), (Object)actual.getHomeInterfaceClass());
            CmpRmiIiopTests.assertEquals((Object)expected.getRemoteInterfaceClass(), (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test46_returnEJBMetaData() {
        try {
            EJBMetaData actual = this.ejbObject.returnEJBMetaData();
            CmpRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((Object)actual.getHomeInterfaceClass(), (Object)actual.getHomeInterfaceClass());
            CmpRmiIiopTests.assertEquals((Object)actual.getRemoteInterfaceClass(), (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test47_returnNestedEJBMetaData() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome home = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EJBMetaData expected = home.getEJBMetaData();
            CmpRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)expected);
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            CmpRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EJBMetaData actual = (EJBMetaData)graph.getObject();
            CmpRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((Object)expected.getHomeInterfaceClass(), (Object)actual.getHomeInterfaceClass());
            CmpRmiIiopTests.assertEquals((Object)expected.getRemoteInterfaceClass(), (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test48_returnNestedEJBMetaData2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedEJBMetaData();
            CmpRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EJBMetaData actual = (EJBMetaData)graph.getObject();
            CmpRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            CmpRmiIiopTests.assertNotNull((String)"The home interface class of the EJBMetaData is null", (Object)actual.getHomeInterfaceClass());
            CmpRmiIiopTests.assertNotNull((String)"The remote interface class of the EJBMetaData is null", (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test49_returnEJBMetaDataArray() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome home = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EJBMetaData[] expected = new EJBMetaData[3];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = home.getEJBMetaData();
                CmpRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)expected[i]);
            }
            EJBMetaData[] actual = this.ejbObject.returnEJBMetaDataArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The EJBMetaData array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                CmpRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual[i]);
                CmpRmiIiopTests.assertEquals((Object)expected[i].getHomeInterfaceClass(), (Object)actual[i].getHomeInterfaceClass());
                CmpRmiIiopTests.assertEquals((Object)expected[i].getRemoteInterfaceClass(), (Object)actual[i].getRemoteInterfaceClass());
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test50_returnHandle() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome home = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncCmpObject object = home.create("test_50 CmpBean");
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)object);
            Handle expected = object.getHandle();
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)expected);
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)expected.getEJBObject());
            Handle actual = this.ejbObject.returnHandle(expected);
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
            EJBObject exp = expected.getEJBObject();
            EJBObject act = actual.getEJBObject();
            CmpRmiIiopTests.assertTrue((String)"The EJBObjects in the Handles are not identical", (boolean)exp.isIdentical(act));
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test51_returnHandle() {
        try {
            Handle actual = this.ejbObject.returnHandle();
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test52_returnNestedHandle() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome home = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncCmpObject object = home.create("test_52 CmpBean");
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)object);
            Handle expected = object.getHandle();
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)expected);
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)expected.getEJBObject());
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            CmpRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            Handle actual = (Handle)graph.getObject();
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
            EJBObject exp = expected.getEJBObject();
            EJBObject act = actual.getEJBObject();
            CmpRmiIiopTests.assertTrue((String)"The EJBObjects in the Handles are not identical", (boolean)exp.isIdentical(act));
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test53_returnNestedHandle2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedHandle();
            CmpRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            Handle actual = (Handle)graph.getObject();
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test54_returnHandleArray() {
        try {
            Object obj = this.initialContext.lookup("client/tests/entity/cmp/EncBean");
            EncCmpHome home = (EncCmpHome)obj;
            CmpRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncCmpObject object = home.create("test_54 CmpBean");
            CmpRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)object);
            Handle[] expected = new Handle[3];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = object.getHandle();
                CmpRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)expected[i]);
            }
            Handle[] actual = this.ejbObject.returnHandleArray(expected);
            CmpRmiIiopTests.assertNotNull((String)"The Handle array returned is null", (Object)actual);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                CmpRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual[i]);
                CmpRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual[i].getEJBObject());
                CmpRmiIiopTests.assertTrue((String)"The EJBObjects in the Handles are not equal", (boolean)expected[i].getEJBObject().isIdentical(actual[i].getEJBObject()));
            }
        }
        catch (Exception e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test55_returnObjectGraph() {
    }

    public void test56_returnObjectGraphArray() {
    }

    public void test57_returnClass() {
        Class[] primitives;
        for (Class expected : primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            try {
                Class actual = this.ejbObject.returnClass(expected);
                CmpRmiIiopTests.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
    }

    public void test58_returnClassArray() {
        try {
            Class[] expected = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
            Class[] actual = this.ejbObject.returnClassArray(expected);
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                CmpRmiIiopTests.assertEquals((Object)expected[i], (Object)actual[i]);
            }
        }
        catch (RemoteException e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test59_returnClassObjectGraph() {
        try {
            Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
            ObjectGraph expectedGraph = new ObjectGraph((Object)primitives);
            ObjectGraph actualGraph = this.ejbObject.returnObjectGraph(expectedGraph);
            Class[] expected = (Class[])expectedGraph.getObject();
            Class[] actual = (Class[])actualGraph.getObject();
            CmpRmiIiopTests.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                CmpRmiIiopTests.assertEquals((Object)expected[i], (Object)actual[i]);
            }
        }
        catch (RemoteException e) {
            CmpRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

