/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.test.TestDatabase;
import org.apache.openejb.test.TestJms;
import org.apache.openejb.test.TestServer;

public class TestManager {
    private static TestServer server;
    private static TestDatabase database;
    private static TestJms jms;
    private static boolean warn;
    static final String TESTSUITE_PROPERTY_FILENAME = "openejb.testsuite.properties";
    static final String TEST_SERVER_CLASSNAME = "openejb.test.server";
    static final String TEST_DATABASE_CLASSNAME = "openejb.test.database";
    static final String TEST_JMS_CLASSNAME = "openejb.test.jms";

    /*
     * Unable to fully structure code
     */
    public static void init(String propertiesFileName) throws Exception {
        props = null;
        try {
            props = new Properties(System.getProperties());
            TestManager.warn = props.getProperty("openejb.test.nowarn") == null;
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Cannot access the system properties: " + e.getClass().getName() + " " + e.getMessage());
        }
        if (propertiesFileName == null) {
            try {
                propertiesFileName = System.getProperty("openejb.testsuite.properties");
                if (propertiesFileName == null) ** GOTO lbl17
                props.putAll((Map<?, ?>)TestManager.getProperties(propertiesFileName));
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Cannot access the system property \"openejb.testsuite.properties\": " + e.getClass().getName() + " " + e.getMessage());
            }
        } else {
            props.putAll((Map<?, ?>)TestManager.getProperties(propertiesFileName));
        }
lbl17:
        // 3 sources

        TestManager.initServer(props);
        TestManager.initDatabase(props);
        TestManager.initJms(props);
    }

    public static void start() throws Exception {
        try {
            if (server != null) {
                server.start();
            }
        }
        catch (Exception e) {
            if (warn) {
                System.out.println("Cannot start the test server: " + e.getClass().getName() + " " + e.getMessage());
            }
            throw e;
        }
        try {
            if (database != null) {
                database.start();
            }
        }
        catch (Exception e) {
            if (warn) {
                System.out.println("Cannot start the test database: " + e.getClass().getName() + " " + e.getMessage());
            }
            throw e;
        }
    }

    public static void stop() throws Exception {
        try {
            if (database != null) {
                database.stop();
            }
        }
        catch (Exception e) {
            if (warn) {
                System.out.println("Cannot stop the test database: " + e.getClass().getName() + " " + e.getMessage());
            }
            throw e;
        }
        try {
            if (server != null) {
                server.stop();
            }
        }
        catch (Exception e) {
            if (warn) {
                System.out.println("Cannot stop the test server 2: " + e.getClass().getName() + " " + e.getMessage());
            }
            throw e;
        }
    }

    private static Properties getProperties(String fileName) throws Exception {
        File file = new File(fileName);
        file = file.getAbsoluteFile();
        Properties props = (Properties)System.getProperties().clone();
        props.load(new FileInputStream(file));
        return props;
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static void initServer(Properties props) {
        try {
            String className = props.getProperty(TEST_SERVER_CLASSNAME);
            if (className == null) {
                throw new IllegalArgumentException("Must specify a test server by setting its class name using the system property \"openejb.test.server\"");
            }
            ClassLoader cl = TestManager.getContextClassLoader();
            Class<?> testServerClass = Class.forName(className, true, cl);
            server = (TestServer)testServerClass.newInstance();
            server.init(props);
        }
        catch (Exception e) {
            if (warn) {
                e.printStackTrace();
            }
            if (warn) {
                System.out.println("Cannot instantiate or initialize the test server: " + e.getClass().getName() + " " + e.getMessage());
            }
            throw new RuntimeException("Cannot instantiate or initialize the test server: " + e.getClass().getName() + " " + e.getMessage(), e);
        }
    }

    private static void initDatabase(Properties props) {
        try {
            String className = props.getProperty(TEST_DATABASE_CLASSNAME);
            if (className == null) {
                throw new IllegalArgumentException("Must specify a test database by setting its class name  using the system property \"openejb.test.database\"");
            }
            ClassLoader cl = TestManager.getContextClassLoader();
            Class<?> testDatabaseClass = Class.forName(className, true, cl);
            database = (TestDatabase)testDatabaseClass.newInstance();
            database.init(props);
        }
        catch (Exception e) {
            if (warn) {
                System.out.println("Cannot instantiate or initialize the test database: " + e.getClass().getName() + " " + e.getMessage());
            }
            throw new RuntimeException("Cannot instantiate or initialize the test database: " + e.getClass().getName() + " " + e.getMessage(), e);
        }
    }

    private static void initJms(Properties props) {
        try {
            String className = props.getProperty(TEST_JMS_CLASSNAME);
            if (className == null) {
                className = "org.apache.openejb.test.ActiveMqTestJms";
            }
            ClassLoader cl = TestManager.getContextClassLoader();
            Class<?> testJmsClass = Class.forName(className, true, cl);
            jms = (TestJms)testJmsClass.newInstance();
            jms.init(props);
        }
        catch (Exception e) {
            if (warn) {
                System.out.println("Cannot instantiate or initialize the test jms: " + e.getClass().getName() + " " + e.getMessage());
            }
            throw new RuntimeException("Cannot instantiate or initialize the test jms: " + e.getClass().getName() + " " + e.getMessage(), e);
        }
    }

    public static TestServer getServer() {
        return server;
    }

    public static TestDatabase getDatabase() {
        return database;
    }

    public static TestJms getJms() {
        return jms;
    }

    public static Properties getContextEnvironment() {
        return server.getContextEnvironment();
    }

    static {
        warn = true;
    }
}

