/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.openejb.Injection;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.server.cxf.rs.Contexts;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.portable.InjectionTargetImpl;

public abstract class CdiResourceProvider
implements ResourceProvider {
    public static final String INSTANCE_KEY = CdiResourceProvider.class.getName() + ".instance";
    protected final Collection<Injection> injections;
    protected final Context context;
    protected final WebBeansContext webbeansContext;
    protected final Class<?> clazz;
    protected final Method postConstructMethod;
    protected final Method preDestroyMethod;
    protected final ClassLoader classLoader;
    protected final Collection<Class<?>> contextTypes = new HashSet();
    protected final BeanCreator normalScopeCreator;
    protected final BeanManagerImpl bm;
    protected final Bean<?> bean;
    protected Constructor<?> constructor;

    public CdiResourceProvider(ClassLoader loader, Class<?> clazz, Collection<Injection> injectionCollection, Context initialContext, WebBeansContext owbCtx) {
        this.injections = injectionCollection;
        this.webbeansContext = owbCtx;
        this.classLoader = loader;
        this.context = (Context)Proxy.newProxyInstance(this.classLoader, new Class[]{Context.class}, (InvocationHandler)new InitialContextWrapper(initialContext));
        this.postConstructMethod = ResourceUtils.findPostConstructMethod(clazz);
        this.preDestroyMethod = ResourceUtils.findPreDestroyMethod(clazz);
        this.bm = this.webbeansContext == null ? null : this.webbeansContext.getBeanManagerImpl();
        this.clazz = clazz;
        if (this.bm != null && this.bm.isInUse()) {
            try {
                Set beans = this.bm.getBeans(clazz, new Annotation[0]);
                this.bean = this.bm.resolve(beans);
            }
            catch (InjectionException ie) {
                String msg = "Resource class " + clazz.getName() + " can not be instantiated";
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
            if (this.bean != null && this.bm.isNormalScope(this.bean.getScope())) {
                this.normalScopeCreator = new ProvidedInstanceBeanCreator(this.bm.getReference(this.bean, (Type)this.bean.getBeanClass(), (CreationalContext)this.bm.createCreationalContext(this.bean)));
            } else {
                this.normalScopeCreator = null;
                this.validateConstructorExists();
            }
        } else {
            this.bean = null;
            this.normalScopeCreator = null;
            this.validateConstructorExists();
        }
        this.findContexts(clazz);
    }

    private void findContexts(Class<?> clazz) {
        if (this.bean instanceof InjectionTargetBean) {
            InterceptorResolutionService.BeanInterceptorInfo info = ((InjectionTargetImpl)InjectionTargetImpl.class.cast(((InjectionTargetBean)InjectionTargetBean.class.cast(this.bean)).getInjectionTarget())).getInterceptorInfo();
            for (Interceptor interceptor : info.getCdiInterceptors()) {
                if (interceptor == null || interceptor.getBeanClass() == null) continue;
                Contexts.findContextFields(interceptor.getBeanClass(), this.contextTypes);
            }
            for (Interceptor interceptor : info.getEjbInterceptors()) {
                if (interceptor == null || interceptor.getBeanClass() == null) continue;
                Contexts.findContextFields(interceptor.getBeanClass(), this.contextTypes);
            }
            for (Decorator decorator : info.getDecorators()) {
                if (decorator == null || decorator.getBeanClass() == null) continue;
                Contexts.findContextFields(decorator.getBeanClass(), this.contextTypes);
            }
        }
        Contexts.findContextFields(clazz, this.contextTypes);
    }

    private void validateConstructorExists() {
        this.constructor = ResourceUtils.findResourceConstructor(this.clazz, (boolean)true);
        if (this.constructor == null) {
            throw new RuntimeException("Resource class " + this.clazz + " has no valid constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInstance(Message m) {
        Object instance;
        Object existing = m.getExchange().get((Object)INSTANCE_KEY);
        if (existing != null) {
            return existing;
        }
        Contexts.bind(m.getExchange(), this.contextTypes);
        BeanCreator creator = this.bean != null ? (this.normalScopeCreator != null ? this.normalScopeCreator : new PseudoScopedCdiBeanCreator()) : new DefaultBeanCreator(m, this.constructor);
        m.put(BeanCreator.class, (Object)creator);
        m.put(CdiResourceProvider.class, (Object)this);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.classLoader);
        try {
            instance = creator.create();
        }
        catch (NoBeanFoundException nbfe) {
            creator = new DefaultBeanCreator(m, this.constructor);
            m.put(BeanCreator.class, (Object)creator);
            instance = creator.create();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        m.getExchange().put((Object)INSTANCE_KEY, instance);
        return instance;
    }

    public void releaseInstance(Message m, Object o) {
        BeanCreator c = (BeanCreator)m.get(BeanCreator.class);
        if (c != null) {
            c.release();
        }
    }

    public Class<?> getResourceClass() {
        return this.clazz;
    }

    public boolean isSingleton() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private static class NoBeanFoundException
    extends RuntimeException {
        public NoBeanFoundException(String name) {
            super(name);
        }
    }

    protected class DefaultBeanCreator
    implements BeanCreator {
        private final Message m;
        private final Constructor<?> constructor;
        private InjectionProcessor<?> injector;
        private CreationalContext creationalContext;
        private Object instance;

        public DefaultBeanCreator(Message m, Constructor<?> constructor) {
            this.m = m;
            this.constructor = constructor;
        }

        protected Object newInstance() throws InstantiationException, IllegalAccessException, InvocationTargetException {
            return this.constructor.newInstance(ResourceUtils.createConstructorArguments(this.constructor, (Message)this.m, (this.m != null ? 1 : 0) != 0));
        }

        @Override
        public Object create() {
            try {
                this.instance = this.newInstance();
                this.doInit();
                return this.instance;
            }
            catch (InstantiationException ex) {
                String msg = "Resource class " + this.constructor.getDeclaringClass().getName() + " can not be instantiated";
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
            catch (IllegalAccessException ex) {
                String msg = "Resource class " + this.constructor.getDeclaringClass().getName() + " can not be instantiated" + " due to IllegalAccessException";
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
            catch (InvocationTargetException ex) {
                String msg = "Resource class " + this.constructor.getDeclaringClass().getName() + " can not be instantiated" + " due to InvocationTargetException";
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
            catch (OpenEJBException e) {
                String msg = "An error occured injecting in class " + this.constructor.getDeclaringClass().getName();
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
        }

        protected void doInit() throws OpenEJBException {
            BeanManagerImpl bm;
            this.injector = new InjectionProcessor(this.instance, new ArrayList<Injection>(CdiResourceProvider.this.injections), InjectionProcessor.unwrap((Context)CdiResourceProvider.this.context));
            this.instance = this.injector.createInstance();
            BeanManagerImpl beanManagerImpl = bm = CdiResourceProvider.this.webbeansContext == null ? null : CdiResourceProvider.this.webbeansContext.getBeanManagerImpl();
            if (bm != null) {
                this.creationalContext = bm.createCreationalContext(null);
                try {
                    OWBInjector.inject((BeanManager)bm, (Object)this.instance, (CreationalContext)this.creationalContext);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            InjectionUtils.invokeLifeCycleMethod((Object)this.instance, (Method)CdiResourceProvider.this.postConstructMethod);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            try {
                InjectionUtils.invokeLifeCycleMethod((Object)this.instance, (Method)CdiResourceProvider.this.preDestroyMethod);
            }
            finally {
                if (this.injector != null) {
                    this.injector.preDestroy();
                }
                if (this.creationalContext != null) {
                    this.creationalContext.release();
                }
            }
        }
    }

    protected class PseudoScopedCdiBeanCreator
    implements BeanCreator {
        private CreationalContext<?> toClean = null;

        protected PseudoScopedCdiBeanCreator() {
        }

        @Override
        public Object create() {
            try {
                this.toClean = CdiResourceProvider.this.bm.createCreationalContext(CdiResourceProvider.this.bean);
                return CdiResourceProvider.this.bm.getReference(CdiResourceProvider.this.bean, (Type)CdiResourceProvider.this.bean.getBeanClass(), this.toClean);
            }
            catch (InjectionException ie) {
                String msg = "Failed to instantiate: " + CdiResourceProvider.this.bean;
                Logger.getInstance((LogCategory)LogCategory.OPENEJB_CDI, this.getClass()).error(msg, (Throwable)ie);
                throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
            }
        }

        @Override
        public void release() {
            this.toClean.release();
            this.toClean = null;
        }
    }

    protected class ProvidedInstanceBeanCreator
    implements BeanCreator {
        private final Object instance;

        protected ProvidedInstanceBeanCreator(Object instance) {
            this.instance = instance;
        }

        @Override
        public Object create() {
            return this.instance;
        }

        @Override
        public void release() {
        }
    }

    protected static interface BeanCreator {
        public Object create();

        public void release();
    }

    private static class InitialContextWrapper
    implements InvocationHandler {
        private final Context ctx;

        public InitialContextWrapper(Context initialContext) {
            this.ctx = initialContext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("lookup")) {
                String name = "java:" + (String)String.class.cast(args[0]);
                if (args[0].getClass().equals(String.class)) {
                    if (this.ctx != null) {
                        try {
                            return this.ctx.lookup(name);
                        }
                        catch (Exception ne) {
                            try {
                                return this.ctx.lookup((String)String.class.cast(args[0]));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    InitialContext initialContext = new InitialContext();
                    try {
                        return initialContext.lookup(name);
                    }
                    catch (Exception swallowed) {
                        try {
                            return initialContext.lookup((String)String.class.cast(args[0]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            try {
                return method.invoke((Object)this.ctx, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }
}

