/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.arquillian.openejb.Closeables;
import org.apache.openejb.arquillian.openejb.SWClassLoader;
import org.apache.openejb.arquillian.openejb.reflection.Assets;
import org.apache.openejb.cdi.CompositeBeans;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WebappAggregatedArchive;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.IO;
import org.apache.openejb.sxc.Sxc;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.apache.xbean.finder.filter.Filter;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.filter.IncludeRegExpPaths;
import org.metatype.sxc.jaxb.JAXBObject;

public class OpenEJBArchiveProcessor {
    private static final Logger LOGGER = Logger.getLogger(OpenEJBArchiveProcessor.class.getName());
    private static final String META_INF = "META-INF/";
    private static final String WEB_INF = "WEB-INF/";
    private static final String EJB_JAR_XML = "ejb-jar.xml";
    private static final String BEANS_XML = "beans.xml";
    private static final String VALIDATION_XML = "validation.xml";
    private static final String RESOURCES_XML = "resources.xml";
    private static final String PERSISTENCE_XML = "persistence.xml";
    private static final String OPENEJB_JAR_XML = "openejb-jar.xml";
    private static final String ENV_ENTRIES_PROPERTIES = "env-entries.properties";
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/";

    public static AppModule createModule(Archive<?> archive, TestClass testClass, Closeables closeables) {
        HashMap<String, Object> testDD;
        String prefix;
        Class javaClass = testClass != null ? testClass.getJavaClass() : null;
        ClassLoader parent = javaClass == null ? Thread.currentThread().getContextClassLoader() : javaClass.getClassLoader();
        ArrayList<URL> additionalPaths = new ArrayList<URL>();
        CompositeArchive scannedArchive = null;
        HashMap<URL, List<String>> earMap = new HashMap<URL, List<String>>();
        HashMap<String, Object> altDD = new HashMap<String, Object>();
        ArrayList<Archive> earLibsArchives = new ArrayList<Archive>();
        CompositeBeans earBeans = new CompositeBeans();
        boolean isEar = EnterpriseArchive.class.isInstance(archive);
        boolean isWebApp = WebArchive.class.isInstance(archive);
        String string = prefix = isWebApp ? WEB_INF : META_INF;
        if (isEar || isWebApp) {
            Map jars = archive.getContent((org.jboss.shrinkwrap.api.Filter)new IncludeRegExpPaths(isEar ? "/.*\\.jar" : "/WEB-INF/lib/.*\\.jar"));
            scannedArchive = OpenEJBArchiveProcessor.analyzeLibs(parent, additionalPaths, earMap, earLibsArchives, earBeans, jars, altDD);
        }
        URL[] urls = additionalPaths.toArray(new URL[additionalPaths.size()]);
        URLClassLoaderFirst swParent = new URLClassLoaderFirst(urls, parent);
        closeables.add((Closeable)swParent);
        if (!isEar) {
            earLibsArchives.add(archive);
        }
        SWClassLoader loader = new SWClassLoader((ClassLoader)swParent, earLibsArchives.toArray(new Archive[earLibsArchives.size()]));
        closeables.add(loader);
        URLClassLoader tempClassLoader = ClassLoaderUtil.createTempClassLoader((ClassLoader)loader);
        closeables.add(tempClassLoader);
        AppModule appModule = new AppModule((ClassLoader)loader, archive.getName());
        if (WEB_INF.equals(prefix)) {
            appModule.setDelegateFirst(false);
            appModule.setStandloneWebModule();
            WebModule webModule = new WebModule(OpenEJBArchiveProcessor.createWebApp(archive), OpenEJBArchiveProcessor.contextRoot(archive.getName()), (ClassLoader)loader, "", appModule.getModuleId());
            webModule.setUrls(additionalPaths);
            appModule.getWebModules().add(webModule);
        } else if (isEar) {
            EjbJar ejbJar;
            AssetSource ejbJarXml;
            FinderFactory.OpenEJBAnnotationFinder earLibFinder = new FinderFactory.OpenEJBAnnotationFinder((org.apache.xbean.finder.archive.Archive)new SimpleWebappAggregatedArchive(tempClassLoader, scannedArchive, earMap));
            appModule.setEarLibFinder((IAnnotationFinder)earLibFinder);
            EjbModule earCdiModule = new EjbModule(appModule.getClassLoader(), "ear-scoped-cdi-beans_" + appModule.getModuleId(), new EjbJar(), new OpenejbJar());
            earCdiModule.setBeans((Beans)earBeans);
            earCdiModule.setFinder((IAnnotationFinder)earLibFinder);
            AssetSource assetSource = ejbJarXml = AssetSource.class.isInstance(altDD.get(EJB_JAR_XML)) ? (AssetSource)((Object)AssetSource.class.cast(altDD.get(EJB_JAR_XML))) : null;
            if (ejbJarXml != null) {
                try {
                    ejbJar = ReadDescriptors.readEjbJar((InputStream)ejbJarXml.get());
                }
                catch (Exception e) {
                    throw new OpenEJBRuntimeException(e);
                }
            } else {
                ejbJar = new EjbJar();
            }
            earCdiModule.setEjbJar(ejbJar);
            appModule.getEjbModules().add(earCdiModule);
            for (Map.Entry node : archive.getContent((org.jboss.shrinkwrap.api.Filter)new IncludeRegExpPaths("/.*\\.war")).entrySet()) {
                Archive webArchive;
                Asset asset = ((Node)node.getValue()).getAsset();
                if (!ArchiveAsset.class.isInstance(asset) || !WebArchive.class.isInstance(webArchive = ((ArchiveAsset)ArchiveAsset.class.cast(asset)).getArchive())) continue;
                HashMap<String, Object> webAltDD = new HashMap<String, Object>();
                Node beansXml = OpenEJBArchiveProcessor.findBeansXml(webArchive, WEB_INF);
                LinkedList<URL> webappAdditionalPaths = new LinkedList<URL>();
                CompositeBeans webAppBeansXml = new CompositeBeans();
                LinkedList<Archive> webAppArchives = new LinkedList<Archive>();
                HashMap<URL, List<String>> webAppClassesByUrl = new HashMap<URL, List<String>>();
                CompositeArchive webAppArchive = OpenEJBArchiveProcessor.analyzeLibs(parent, webappAdditionalPaths, webAppClassesByUrl, webAppArchives, webAppBeansXml, webArchive.getContent((org.jboss.shrinkwrap.api.Filter)new IncludeRegExpPaths("/WEB-INF/lib/.*\\.jar")), webAltDD);
                webAppArchives.add(webArchive);
                SWClassLoader webLoader = new SWClassLoader(parent, webAppArchives.toArray(new Archive[webAppArchives.size()]));
                closeables.add(webLoader);
                FinderFactory.OpenEJBAnnotationFinder finder = new FinderFactory.OpenEJBAnnotationFinder(OpenEJBArchiveProcessor.finderArchive(beansXml, webArchive, webLoader, webAppArchive, webAppClassesByUrl, webAppBeansXml));
                String contextRoot = OpenEJBArchiveProcessor.contextRoot(webArchive.getName());
                WebModule webModule = new WebModule(OpenEJBArchiveProcessor.createWebApp(webArchive), contextRoot, (ClassLoader)webLoader, "", appModule.getModuleId() + "_" + contextRoot);
                webModule.setUrls(Collections.emptyList());
                webModule.setScannableUrls(Collections.emptyList());
                webModule.setFinder((IAnnotationFinder)finder);
                EjbJar webEjbJar = OpenEJBArchiveProcessor.createEjbJar(prefix, webArchive);
                EjbModule ejbModule = new EjbModule((ClassLoader)webLoader, webModule.getModuleId(), null, webEjbJar, new OpenejbJar());
                ejbModule.setBeans((Beans)webAppBeansXml);
                ejbModule.getAltDDs().putAll(webAltDD);
                ejbModule.getAltDDs().put(BEANS_XML, webAppBeansXml);
                ejbModule.setFinder((IAnnotationFinder)finder);
                ejbModule.setClassLoader((ClassLoader)webLoader);
                ejbModule.setWebapp(true);
                appModule.getEjbModules().add(ejbModule);
                appModule.getWebModules().add(webModule);
                OpenEJBArchiveProcessor.addPersistenceXml(archive, WEB_INF, appModule);
                OpenEJBArchiveProcessor.addOpenEJbJarXml(archive, WEB_INF, ejbModule);
                OpenEJBArchiveProcessor.addValidationXml(archive, WEB_INF, new HashMap<String, Object>(), ejbModule);
                OpenEJBArchiveProcessor.addResourcesXml(archive, WEB_INF, ejbModule);
                OpenEJBArchiveProcessor.addEnvEntries(archive, WEB_INF, appModule, ejbModule);
            }
        }
        if (isEar) {
            OpenEJBArchiveProcessor.addTestClassAsManagedBean(javaClass, tempClassLoader, appModule);
            return appModule;
        }
        if (javaClass != null) {
            EjbModule testEjbModule = OpenEJBArchiveProcessor.addTestClassAsManagedBean(javaClass, tempClassLoader, appModule);
            testDD = testEjbModule.getAltDDs();
        } else {
            testDD = new HashMap();
        }
        EjbJar ejbJar = OpenEJBArchiveProcessor.createEjbJar(prefix, archive);
        if (ejbJar.getModuleName() == null) {
            String name = archive.getName();
            if (name.endsWith("ar") && name.length() > 4) {
                ejbJar.setModuleName(name.substring(0, name.length() - ".jar".length()));
            } else {
                ejbJar.setModuleName(name);
            }
        }
        EjbModule ejbModule = new EjbModule(ejbJar);
        ejbModule.setClassLoader((ClassLoader)tempClassLoader);
        Node beansXml = OpenEJBArchiveProcessor.findBeansXml(archive, prefix);
        FinderFactory.OpenEJBAnnotationFinder finder = new FinderFactory.OpenEJBAnnotationFinder(OpenEJBArchiveProcessor.finderArchive(beansXml, archive, loader, scannedArchive, earMap, earBeans));
        ejbModule.setFinder((IAnnotationFinder)finder);
        ejbModule.setBeans((Beans)earBeans);
        ejbModule.getAltDDs().put(BEANS_XML, earBeans);
        if (appModule.isWebapp()) {
            ((WebModule)appModule.getWebModules().iterator().next()).setFinder(ejbModule.getFinder());
        }
        appModule.getEjbModules().add(ejbModule);
        OpenEJBArchiveProcessor.addPersistenceXml(archive, prefix, appModule);
        OpenEJBArchiveProcessor.addOpenEJbJarXml(archive, prefix, ejbModule);
        OpenEJBArchiveProcessor.addValidationXml(archive, prefix, testDD, ejbModule);
        OpenEJBArchiveProcessor.addResourcesXml(archive, prefix, ejbModule);
        OpenEJBArchiveProcessor.addEnvEntries(archive, prefix, appModule, ejbModule);
        if (!appModule.isWebapp()) {
            appModule.getAdditionalLibraries().addAll(additionalPaths);
        }
        if (archive.getName().endsWith(".jar")) {
            appModule.setStandloneWebModule();
        }
        return appModule;
    }

    private static EjbJar createEjbJar(String prefix, Archive<?> webArchive) {
        EjbJar webEjbJar;
        Node webEjbJarXml = webArchive.get(prefix.concat(EJB_JAR_XML));
        if (webEjbJarXml != null) {
            try {
                webEjbJar = ReadDescriptors.readEjbJar((InputStream)webEjbJarXml.getAsset().openStream());
            }
            catch (OpenEJBException e) {
                throw new OpenEJBRuntimeException((Exception)((Object)e));
            }
        } else {
            webEjbJar = new EjbJar();
        }
        return webEjbJar;
    }

    private static EjbModule addTestClassAsManagedBean(Class<?> javaClass, URLClassLoader tempClassLoader, AppModule appModule) {
        EjbJar ejbJar = new EjbJar();
        OpenejbJar openejbJar = new OpenejbJar();
        String ejbName = appModule.getModuleId() + "_" + javaClass.getName();
        ManagedBean bean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(ejbName, javaClass.getName(), true));
        bean.localBean();
        bean.setTransactionType(TransactionType.BEAN);
        EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)bean);
        ejbDeployment.setDeploymentId(ejbName);
        EjbModule e = new EjbModule(ejbJar, openejbJar);
        e.getProperties().setProperty("openejb.cdi.activated", "false");
        e.getProperties().setProperty("openejb.test.module", "true");
        e.setBeans(new Beans());
        e.setClassLoader((ClassLoader)tempClassLoader);
        appModule.getEjbModules().add(e);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WebApp createWebApp(Archive<?> archive) {
        WebApp webApp;
        Node webXml = archive.get("WEB-INF/web.xml");
        if (webXml == null) {
            webApp = new WebApp();
        } else {
            InputStream inputStream = null;
            try {
                inputStream = webXml.getAsset().openStream();
                webApp = (WebApp)Sxc.unmarshalJavaee((JAXBObject)new WebApp.JAXB(), (InputStream)inputStream);
            }
            catch (Exception e) {
                webApp = new WebApp();
            }
            finally {
                IO.close((Closeable)inputStream);
            }
        }
        return webApp;
    }

    private static CompositeArchive analyzeLibs(ClassLoader parent, List<URL> additionalPaths, Map<URL, List<String>> earMap, List<Archive> earLibsArchives, CompositeBeans earBeans, Map<ArchivePath, Node> jars, Map<String, Object> altDD) {
        ArrayList<Object> archives = new ArrayList<Object>(jars.size());
        for (Map.Entry<ArchivePath, Node> node : jars.entrySet()) {
            Asset asset = node.getValue().getAsset();
            if (ArchiveAsset.class.isInstance(asset)) {
                Node ejbJarXml;
                Archive libArchive = ((ArchiveAsset)ArchiveAsset.class.cast(asset)).getArchive();
                if (!OpenEJBArchiveProcessor.isExcluded(libArchive.getName())) {
                    earLibsArchives.add(libArchive);
                    ArrayList earClasses = new ArrayList();
                    ArrayList<String> earClassNames = new ArrayList<String>();
                    Map content = libArchive.getContent((org.jboss.shrinkwrap.api.Filter)new IncludeRegExpPaths(".*.class"));
                    for (Map.Entry classNode : content.entrySet()) {
                        String classname = OpenEJBArchiveProcessor.name(((ArchivePath)classNode.getKey()).get());
                        try {
                            earClasses.add(parent.loadClass(classname));
                            earClassNames.add(classname);
                        }
                        catch (ClassNotFoundException e) {
                            LOGGER.fine("Can't load class " + classname);
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {}
                    }
                    try {
                        Node beansNode = libArchive.get("META-INF/beans.xml");
                        URL arUrl = new URL("jar:file://!/lib/" + libArchive.getName() + (beansNode != null ? "!/META-INF/beans.xml" : ""));
                        if (beansNode != null) {
                            try {
                                DeploymentLoader.doMerge((URL)arUrl, (CompositeBeans)earBeans, (Beans)ReadDescriptors.readBeans((InputStream)beansNode.getAsset().openStream()));
                            }
                            catch (OpenEJBException e) {
                                throw new IllegalArgumentException(e);
                            }
                        }
                        earMap.put(arUrl, earClassNames);
                    }
                    catch (MalformedURLException beansNode) {
                        // empty catch block
                    }
                    archives.add(new ClassesArchive(earClasses));
                }
                if ((ejbJarXml = libArchive.get("META-INF/ejb-jar.xml")) != null) {
                    altDD.put(EJB_JAR_XML, (Object)new AssetSource(ejbJarXml.getAsset(), null));
                }
            }
            if (!UrlAsset.class.isInstance(asset) && !FileAsset.class.isInstance(asset)) continue;
            try {
                URL url = UrlAsset.class.isInstance(asset) ? Assets.get(URL.class, "url", asset) : Assets.get(File.class, "file", asset).toURI().toURL();
                ArrayList classes = new ArrayList();
                archives.add(new FilteredArchive((org.apache.xbean.finder.archive.Archive)new JarArchive(parent, url), (Filter)new WebappAggregatedArchive.ScanXmlSaverFilter(false, null, classes, null)));
                additionalPaths.add(url);
                URLClassLoader loader = new URLClassLoader(new URL[]{url}, Assets.EMPTY_LOADER);
                for (String beans : Arrays.asList("META-INF/beans.xml", "/META-INF/beans.xml")) {
                    URL u = loader.getResource(beans);
                    if (u == null) continue;
                    try {
                        DeploymentLoader.doMerge((URL)u, (CompositeBeans)earBeans, (Beans)ReadDescriptors.readBeans((InputStream)u.openStream()));
                    }
                    catch (OpenEJBException e) {
                        throw new IllegalArgumentException(e);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    earMap.put(u, classes);
                }
                try {
                    loader.close();
                }
                catch (IOException iOException) {}
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return new CompositeArchive(archives);
    }

    private static Node findBeansXml(Archive<?> archive, String prefix) {
        Node beansXml = archive.get(prefix.concat(BEANS_XML));
        if (beansXml == null && WEB_INF.equals(prefix)) {
            beansXml = archive.get(WEB_INF_CLASSES.concat(META_INF).concat(BEANS_XML));
        }
        return beansXml;
    }

    private static void addPersistenceXml(Archive<?> archive, String prefix, AppModule appModule) {
        Node persistenceXml = archive.get(prefix.concat(PERSISTENCE_XML));
        if (persistenceXml == null && WEB_INF.equals(prefix)) {
            persistenceXml = archive.get(WEB_INF_CLASSES.concat(META_INF).concat(PERSISTENCE_XML));
        }
        if (persistenceXml != null) {
            Asset asset = persistenceXml.getAsset();
            if (UrlAsset.class.isInstance(asset)) {
                appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(Assets.get(URL.class, "url", asset)));
            } else if (FileAsset.class.isInstance(asset)) {
                try {
                    appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(Assets.get(File.class, "file", asset).toURI().toURL()));
                }
                catch (MalformedURLException e) {
                    appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(new AssetSource(persistenceXml.getAsset(), null)));
                }
            } else if (ClassLoaderAsset.class.isInstance(asset)) {
                URL url = Assets.get(ClassLoader.class, "classLoader", asset).getResource(Assets.get(String.class, "resourceName", asset));
                if (url != null) {
                    appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(url));
                } else {
                    appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(new AssetSource(persistenceXml.getAsset(), null)));
                }
            } else {
                appModule.getAltDDs().put(PERSISTENCE_XML, Arrays.asList(new AssetSource(persistenceXml.getAsset(), null)));
            }
        }
    }

    private static void addOpenEJbJarXml(Archive<?> archive, String prefix, EjbModule ejbModule) {
        Node openejbJarXml = archive.get(prefix.concat(OPENEJB_JAR_XML));
        if (openejbJarXml != null) {
            ejbModule.getAltDDs().put(OPENEJB_JAR_XML, new AssetSource(openejbJarXml.getAsset(), null));
        }
    }

    private static void addValidationXml(Archive<?> archive, String prefix, Map<String, Object> testDD, EjbModule ejbModule) {
        Node validationXml = archive.get(prefix.concat(VALIDATION_XML));
        if (validationXml == null && WEB_INF == prefix) {
            validationXml = archive.get(WEB_INF_CLASSES.concat(META_INF).concat(VALIDATION_XML));
        }
        if (validationXml != null) {
            testDD.put(VALIDATION_XML, (Object)new AssetSource(validationXml.getAsset(), null));
            ejbModule.getAltDDs().put(VALIDATION_XML, new AssetSource(validationXml.getAsset(), null));
        }
    }

    private static void addResourcesXml(Archive<?> archive, String prefix, EjbModule ejbModule) {
        Node resourcesXml = archive.get(prefix.concat(RESOURCES_XML));
        if (resourcesXml != null) {
            ejbModule.getAltDDs().put(RESOURCES_XML, new AssetSource(resourcesXml.getAsset(), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEnvEntries(Archive<?> archive, String prefix, AppModule appModule, EjbModule ejbModule) {
        Node envEntriesProperties = archive.get(prefix.concat(ENV_ENTRIES_PROPERTIES));
        if (envEntriesProperties != null) {
            InputStream is = null;
            Properties properties = new Properties();
            try {
                is = envEntriesProperties.getAsset().openStream();
                properties.load(is);
                ejbModule.getAltDDs().put(ENV_ENTRIES_PROPERTIES, properties);
                ((EjbModule)appModule.getEjbModules().iterator().next()).getAltDDs().put(ENV_ENTRIES_PROPERTIES, properties);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "can't read env-entries.properties", e);
            }
            finally {
                IO.close((Closeable)is);
            }
        }
    }

    private static String contextRoot(String name) {
        if (name.endsWith(".war")) {
            return name.substring(0, name.length() - ".war".length());
        }
        return name;
    }

    private static org.apache.xbean.finder.archive.Archive finderArchive(Node beansXml, Archive<?> archive, ClassLoader cl, CompositeArchive libs, Map<URL, List<String>> webAppClassesByUrl, CompositeBeans compositeBeans) {
        ArrayList classes = new ArrayList();
        Map content = archive.getContent((org.jboss.shrinkwrap.api.Filter)new IncludeRegExpPaths(".*.class"));
        for (Map.Entry node : content.entrySet()) {
            String classname = OpenEJBArchiveProcessor.name(((ArchivePath)node.getKey()).get());
            try {
                classes.add(cl.loadClass(classname));
            }
            catch (ClassNotFoundException e) {
                LOGGER.fine("Can't load class " + classname);
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                e.printStackTrace(System.err);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        ArrayList<Object> archives = new ArrayList<Object>();
        archives.add(new ClassesArchive(classes));
        if (beansXml != null) {
            try {
                URL key = new URL("jar:file://!/WEB-INF/beans.xml");
                try {
                    DeploymentLoader.doMerge((URL)key, (CompositeBeans)compositeBeans, (Beans)ReadDescriptors.readBeans((InputStream)beansXml.getAsset().openStream()));
                }
                catch (OpenEJBException e) {
                    throw new IllegalArgumentException(e);
                }
                ArrayList<String> mainClasses = new ArrayList<String>();
                for (Class clazz : classes) {
                    mainClasses.add(clazz.getName());
                }
                webAppClassesByUrl.put(key, mainClasses);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (libs != null) {
            archives.add(libs);
        }
        return new SimpleWebappAggregatedArchive(cl, new CompositeArchive(archives), webAppClassesByUrl);
    }

    private static boolean isExcluded(String archiveName) {
        return "arquillian-junit.jar".equals(archiveName) || "arquillian-protocol.jar".equals(archiveName) || "arquillian-core.jar".equals(archiveName);
    }

    private static String name(String raw) {
        String name = raw;
        if (name.startsWith(WEB_INF_CLASSES)) {
            name = name.substring(WEB_INF_CLASSES.length() - 1);
        }
        name = name.replace('/', '.');
        return name.substring(1, name.length() - 6);
    }

    private static class SimpleWebappAggregatedArchive
    extends WebappAggregatedArchive {
        private final CompositeArchive delegate;
        private final Map<URL, List<String>> classesMap;

        public SimpleWebappAggregatedArchive(ClassLoader cl, CompositeArchive archive, Map<URL, List<String>> map) {
            super(cl, new HashMap(), new ArrayList());
            this.delegate = archive;
            this.classesMap = map;
        }

        public Map<URL, List<String>> getClassesMap() {
            return this.classesMap;
        }

        public InputStream getBytecode(String s) throws IOException, ClassNotFoundException {
            return this.delegate.getBytecode(s);
        }

        public Class<?> loadClass(String s) throws ClassNotFoundException {
            return this.delegate.loadClass(s);
        }

        public Iterator<Archive.Entry> iterator() {
            return this.delegate.iterator();
        }
    }

    private static final class AssetSource
    extends ReadDescriptors.UrlSource {
        private Asset asset;

        private AssetSource(Asset asset, URL url) {
            super(url);
            this.asset = asset;
        }

        public InputStream get() throws IOException {
            return this.asset.openStream();
        }

        public String toString() {
            return "AssetSource{asset=" + String.valueOf(this.asset) + "}";
        }
    }
}

