/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.microprofile.client;

import io.opentracing.Tracer;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.client.ClientBuilder;
import org.apache.geronimo.microprofile.opentracing.microprofile.client.OpenTracingClientRequestFilter;
import org.apache.geronimo.microprofile.opentracing.microprofile.client.OpenTracingClientResponseFilter;
import org.apache.geronimo.microprofile.opentracing.microprofile.client.SyncExecutor;
import org.apache.geronimo.microprofile.opentracing.microprofile.thread.OpenTracingExecutorService;
import org.eclipse.microprofile.opentracing.ClientTracingRegistrarProvider;

public class GeronimoClientTracingRegistrarProvider
implements ClientTracingRegistrarProvider {
    private final OpenTracingClientRequestFilter requestFilter;
    private final OpenTracingClientResponseFilter responseFilter;
    private final Tracer tracer;

    public GeronimoClientTracingRegistrarProvider() {
        CDI cdi = CDI.current();
        this.requestFilter = (OpenTracingClientRequestFilter)cdi.select(OpenTracingClientRequestFilter.class, new Annotation[0]).get();
        this.responseFilter = (OpenTracingClientResponseFilter)cdi.select(OpenTracingClientResponseFilter.class, new Annotation[0]).get();
        this.tracer = (Tracer)cdi.select(Tracer.class, new Annotation[0]).get();
    }

    public ClientBuilder configure(ClientBuilder builder) {
        return this.configure(builder, new SyncExecutor());
    }

    public ClientBuilder configure(ClientBuilder builder, ExecutorService executorService) {
        if (builder.getConfiguration().getInstances().stream().anyMatch(it -> this.requestFilter == it)) {
            return builder;
        }
        return ((ClientBuilder)((ClientBuilder)builder.register((Object)this.requestFilter)).register((Object)this.responseFilter)).executorService(this.wrapExecutor(executorService));
    }

    private ExecutorService wrapExecutor(ExecutorService executorService) {
        if (OpenTracingExecutorService.class.isInstance(executorService)) {
            return executorService;
        }
        return new OpenTracingExecutorService(executorService, this.tracer);
    }
}

