/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.impl;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.geronimo.microprofile.opentracing.impl.GeronimoTracer;
import org.apache.geronimo.microprofile.opentracing.impl.IdGenerator;
import org.apache.geronimo.microprofile.opentracing.impl.ReferenceImpl;
import org.apache.geronimo.microprofile.opentracing.impl.SpanContextImpl;
import org.apache.geronimo.microprofile.opentracing.impl.SpanImpl;

public class SpanBuilderImpl
implements Tracer.SpanBuilder {
    private final GeronimoTracer tracer;
    private final Consumer<SpanImpl> onFinish;
    private final String operationName;
    private final Collection<ReferenceImpl> references = new ArrayList<ReferenceImpl>();
    private final Map<String, Object> tags = new HashMap<String, Object>();
    private final IdGenerator idGenerator;
    private boolean ignoreActiveSpan;
    private long timestamp = -1L;

    public SpanBuilderImpl(GeronimoTracer tracer, Consumer<SpanImpl> onFinish, String operationName, IdGenerator idGenerator) {
        this.tracer = tracer;
        this.onFinish = onFinish;
        this.operationName = operationName;
        this.idGenerator = idGenerator;
    }

    public Tracer.SpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    public Tracer.SpanBuilder asChildOf(Span parent) {
        if (parent == null) {
            return this;
        }
        return this.asChildOf(parent.context());
    }

    public Tracer.SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
        this.references.add(new ReferenceImpl(referenceType, (SpanContextImpl)SpanContextImpl.class.cast(referencedContext)));
        return this;
    }

    public Tracer.SpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        this.tags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        this.tags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        this.timestamp = microseconds;
        return this;
    }

    public Scope startActive(boolean finishSpanOnClose) {
        return this.tracer.scopeManager().activate(this.startManual(), finishSpanOnClose);
    }

    public Span startManual() {
        Span span;
        if (this.timestamp < 0L) {
            this.timestamp = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        }
        if (!this.ignoreActiveSpan && this.references.stream().noneMatch(it -> it.getType().equalsIgnoreCase("child_of")) && (span = this.tracer.activeSpan()) != null) {
            this.addReference("child_of", span.context());
        }
        ReferenceImpl parent = this.references.stream().filter(it -> "child_of".equals(it.getType())).findFirst().orElseGet(() -> this.references.isEmpty() ? null : this.references.iterator().next());
        Map<String, String> baggages = this.references.stream().flatMap(r -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(r.getValue().baggageItems().iterator(), 1024), false)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        SpanContextImpl context = parent == null ? this.tracer.newContext(this.idGenerator.next(), null, this.idGenerator.next(), baggages) : this.tracer.newContext(parent.getValue().getTraceId(), parent.getValue().getSpanId(), this.idGenerator.next(), baggages);
        return new SpanImpl(this.operationName, this.timestamp, this.references, this.tags, this.onFinish, context);
    }

    public Span start() {
        return this.startManual();
    }
}

