/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.util.Collections;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JohnzonJsonParser;
import org.apache.johnzon.core.JsonArrayBuilderImpl;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonObjectBuilderImpl;
import org.apache.johnzon.core.JsonProviderImpl;
import org.apache.johnzon.core.JsonStringImpl;
import org.apache.johnzon.core.RejectDuplicateKeysMode;

public class JsonReaderImpl
implements JsonReader {
    private final JohnzonJsonParser parser;
    private final BufferStrategy.BufferProvider<char[]> bufferProvider;
    private JsonProviderImpl provider;
    private final RejectDuplicateKeysMode rejectDuplicateKeysMode;
    private boolean closed = false;
    private boolean subStreamReader;

    public JsonReaderImpl(JsonParser parser, BufferStrategy.BufferProvider<char[]> bufferProvider, RejectDuplicateKeysMode rejectDuplicateKeysMode, JsonProviderImpl provider) {
        this(parser, false, bufferProvider, rejectDuplicateKeysMode, provider);
    }

    public JsonReaderImpl(JsonParser parser, boolean subStreamReader, BufferStrategy.BufferProvider<char[]> bufferProvider, RejectDuplicateKeysMode rejectDuplicateKeys, JsonProviderImpl provider) {
        this.bufferProvider = bufferProvider;
        this.provider = provider;
        this.parser = parser instanceof JohnzonJsonParser ? (JohnzonJsonParser)parser : new JohnzonJsonParser.JohnzonJsonParserWrapper(parser);
        this.subStreamReader = subStreamReader;
        this.rejectDuplicateKeysMode = rejectDuplicateKeys;
    }

    public JsonStructure read() {
        return (JsonStructure)JsonStructure.class.cast(this.readValue());
    }

    public JsonValue readValue() {
        this.checkClosed();
        if (!this.parser.hasNext()) {
            throw new NothingToRead();
        }
        JsonParser.Event next = this.subStreamReader ? this.parser.current() : this.parser.next();
        switch (next) {
            case START_OBJECT: {
                JsonObjectBuilderImpl objectBuilder = new JsonObjectBuilderImpl(Collections.emptyMap(), this.bufferProvider, this.rejectDuplicateKeysMode, this.provider);
                this.parseObject(objectBuilder);
                if (!this.subStreamReader && this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                return objectBuilder.build();
            }
            case START_ARRAY: {
                JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl(Collections.emptyList(), this.bufferProvider, this.rejectDuplicateKeysMode, this.provider);
                this.parseArray(arrayBuilder);
                if (!this.subStreamReader && this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                return arrayBuilder.build();
            }
            case VALUE_STRING: {
                JsonStringImpl string = new JsonStringImpl(this.parser.getString());
                if (!this.subStreamReader && this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                return string;
            }
            case VALUE_FALSE: {
                if (!this.subStreamReader && this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                return JsonValue.FALSE;
            }
            case VALUE_TRUE: {
                if (!this.subStreamReader && this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                return JsonValue.TRUE;
            }
            case VALUE_NULL: {
                if (!this.subStreamReader && this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                return JsonValue.NULL;
            }
            case VALUE_NUMBER: {
                JsonNumber number = this.parser.isFitLong() ? new JsonLongImpl(this.parser.getLong()) : new JsonNumberImpl(this.parser.getBigDecimal(), this.provider::checkBigDecimalScale);
                if (!this.subStreamReader && this.parser.hasNext()) {
                    throw new JsonParsingException("Expected end of file", this.parser.getLocation());
                }
                return number;
            }
        }
        this.close();
        throw new JsonParsingException("Unknown structure: " + next, this.parser.getLocation());
    }

    public JsonObject readObject() {
        JsonStructure read = this.read();
        this.checkType(JsonObject.class, read);
        return (JsonObject)JsonObject.class.cast(read);
    }

    public JsonArray readArray() {
        JsonStructure read = this.read();
        this.checkType(JsonArray.class, read);
        return (JsonArray)JsonArray.class.cast(read);
    }

    private void checkType(Class<?> expected, JsonStructure read) {
        if (!expected.isInstance(read)) {
            throw new JsonParsingException("Expecting " + expected + " but got " + read, this.parser.getLocation());
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.parser.close();
        }
    }

    private void parseObject(JsonObjectBuilder builder) {
        String key = null;
        block12: while (this.parser.hasNext()) {
            JsonParser.Event next = this.parser.next();
            switch (next) {
                case KEY_NAME: {
                    key = this.parser.getString();
                    continue block12;
                }
                case VALUE_STRING: {
                    builder.add(key, (JsonValue)new JsonStringImpl(this.parser.getString()));
                    continue block12;
                }
                case START_OBJECT: {
                    JsonObjectBuilderImpl subObject = new JsonObjectBuilderImpl(Collections.emptyMap(), this.bufferProvider, this.rejectDuplicateKeysMode, this.provider);
                    this.parseObject(subObject);
                    builder.add(key, (JsonObjectBuilder)subObject);
                    continue block12;
                }
                case START_ARRAY: {
                    JsonArrayBuilderImpl subArray = new JsonArrayBuilderImpl(Collections.emptyList(), this.bufferProvider, this.rejectDuplicateKeysMode, this.provider);
                    this.parseArray(subArray);
                    builder.add(key, (JsonArrayBuilder)subArray);
                    continue block12;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isIntegralNumber() && this.parser.isNotTooLong()) {
                        builder.add(key, (JsonValue)new JsonLongImpl(this.parser.getLong()));
                        continue block12;
                    }
                    builder.add(key, (JsonValue)new JsonNumberImpl(this.parser.getBigDecimal(), this.provider::checkBigDecimalScale));
                    continue block12;
                }
                case VALUE_NULL: {
                    builder.addNull(key);
                    continue block12;
                }
                case VALUE_TRUE: {
                    builder.add(key, true);
                    continue block12;
                }
                case VALUE_FALSE: {
                    builder.add(key, false);
                    continue block12;
                }
                case END_OBJECT: {
                    return;
                }
                case END_ARRAY: {
                    throw new JsonParsingException("']', shouldn't occur", this.parser.getLocation());
                }
            }
            throw new JsonParsingException(next.name() + ", shouldn't occur", this.parser.getLocation());
        }
    }

    private void parseArray(JsonArrayBuilder builder) {
        block12: while (this.parser.hasNext()) {
            JsonParser.Event next = this.parser.next();
            switch (next) {
                case VALUE_STRING: {
                    builder.add((JsonValue)new JsonStringImpl(this.parser.getString()));
                    continue block12;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isFitLong()) {
                        builder.add((JsonValue)new JsonLongImpl(this.parser.getLong()));
                        continue block12;
                    }
                    builder.add((JsonValue)new JsonNumberImpl(this.parser.getBigDecimal(), this.provider::checkBigDecimalScale));
                    continue block12;
                }
                case START_OBJECT: {
                    JsonObjectBuilderImpl subObject = new JsonObjectBuilderImpl(Collections.emptyMap(), this.bufferProvider, this.rejectDuplicateKeysMode, this.provider);
                    this.parseObject(subObject);
                    builder.add((JsonObjectBuilder)subObject);
                    continue block12;
                }
                case START_ARRAY: {
                    JsonArrayBuilderImpl subArray = null;
                    subArray = new JsonArrayBuilderImpl(Collections.emptyList(), this.bufferProvider, this.rejectDuplicateKeysMode, this.provider);
                    this.parseArray(subArray);
                    builder.add((JsonArrayBuilder)subArray);
                    continue block12;
                }
                case END_ARRAY: {
                    return;
                }
                case VALUE_NULL: {
                    builder.addNull();
                    continue block12;
                }
                case VALUE_TRUE: {
                    builder.add(true);
                    continue block12;
                }
                case VALUE_FALSE: {
                    builder.add(false);
                    continue block12;
                }
                case KEY_NAME: {
                    throw new JsonParsingException("array doesn't have keys", this.parser.getLocation());
                }
                case END_OBJECT: {
                    throw new JsonParsingException("'}', shouldn't occur", this.parser.getLocation());
                }
            }
            throw new JsonParsingException(next.name() + ", shouldn't occur", this.parser.getLocation());
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("read(), readObject(), readArray() or close() method was already called");
        }
    }

    public static class NothingToRead
    extends IllegalStateException {
        public NothingToRead() {
            super("Nothing to read");
        }
    }
}

