/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.provider;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.inject.spi.CDI;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.module.ServerAuthModule;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import org.apache.tomee.security.cdi.TomEESecurityServletAuthenticationMechanismMapper;
import org.apache.tomee.security.http.TomEEHttpMessageContext;

public class TomEESecurityServerAuthModule
implements ServerAuthModule {
    private CallbackHandler handler;

    public Class[] getSupportedMessageTypes() {
        return new Class[0];
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        TomEEHttpMessageContext httpMessageContext = TomEEHttpMessageContext.httpMessageContext(this.handler, messageInfo, subject, null);
        ((TomEESecurityServletAuthenticationMechanismMapper)CDI.current().select(TomEESecurityServletAuthenticationMechanismMapper.class, new Annotation[0]).get()).getCurrentAuthenticationMechanism(httpMessageContext).cleanSubject(httpMessageContext.getRequest(), httpMessageContext.getResponse(), (HttpMessageContext)httpMessageContext);
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject subject) throws AuthException {
        AuthenticationStatus authenticationStatus;
        TomEEHttpMessageContext httpMessageContext = TomEEHttpMessageContext.httpMessageContext(this.handler, messageInfo, subject, null);
        HttpAuthenticationMechanism authenticationMechanism = ((TomEESecurityServletAuthenticationMechanismMapper)CDI.current().select(TomEESecurityServletAuthenticationMechanismMapper.class, new Annotation[0]).get()).getCurrentAuthenticationMechanism(httpMessageContext);
        try {
            authenticationStatus = authenticationMechanism.secureResponse(httpMessageContext.getRequest(), httpMessageContext.getResponse(), (HttpMessageContext)httpMessageContext);
        }
        catch (AuthenticationException e) {
            AuthException authException = new AuthException(e.getMessage());
            authException.initCause((Throwable)e);
            throw authException;
        }
        return this.mapToAuthStatus(authenticationStatus);
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        AuthenticationStatus authenticationStatus;
        TomEEHttpMessageContext httpMessageContext = TomEEHttpMessageContext.httpMessageContext(this.handler, messageInfo, clientSubject, serviceSubject);
        HttpAuthenticationMechanism authenticationMechanism = ((TomEESecurityServletAuthenticationMechanismMapper)CDI.current().select(TomEESecurityServletAuthenticationMechanismMapper.class, new Annotation[0]).get()).getCurrentAuthenticationMechanism(httpMessageContext);
        try {
            authenticationStatus = authenticationMechanism.validateRequest(httpMessageContext.getRequest(), httpMessageContext.getResponse(), (HttpMessageContext)httpMessageContext);
        }
        catch (AuthenticationException e) {
            AuthException authException = new AuthException(e.getMessage());
            authException.initCause((Throwable)e);
            throw authException;
        }
        return this.mapToAuthStatus(authenticationStatus);
    }

    private AuthStatus mapToAuthStatus(AuthenticationStatus authenticationStatus) {
        switch (authenticationStatus) {
            case SUCCESS: 
            case NOT_DONE: {
                return AuthStatus.SUCCESS;
            }
            case SEND_FAILURE: {
                return AuthStatus.SEND_FAILURE;
            }
            case SEND_CONTINUE: {
                return AuthStatus.SEND_CONTINUE;
            }
        }
        throw new IllegalArgumentException();
    }
}

