/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.identitystore;

import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.IdentityStorePermission;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
public class TomEELDAPIdentityStore
implements IdentityStore {
    private static final String DEFAULT_USER_FILTER = "(&(%s=%s)(|(objectclass=user)(objectclass=person)(objectclass=inetOrgPerson)(objectclass=organizationalPerson))(!(objectclass=computer)))";
    private static final String DEFAULT_GROUP_FILTER = "(&(%s=%s)(|(objectclass=group)(objectclass=groupofnames)(objectclass=groupofuniquenames)))";
    @Inject
    private Supplier<LdapIdentityStoreDefinition> definitionSupplier;
    private LdapIdentityStoreDefinition definition;
    private Set<IdentityStore.ValidationType> validationTypes;

    @PostConstruct
    private void init() throws Exception {
        this.definition = this.definitionSupplier.get();
        this.validationTypes = new HashSet<IdentityStore.ValidationType>(Arrays.asList(this.definition.useFor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CredentialValidationResult validate(Credential credential) {
        String callerDn;
        String callerName;
        LdapContext ldapContext;
        block7: {
            UsernamePasswordCredential usernamePasswordCredential;
            block6: {
                if (!(credential instanceof UsernamePasswordCredential)) {
                    return CredentialValidationResult.NOT_VALIDATED_RESULT;
                }
                usernamePasswordCredential = (UsernamePasswordCredential)credential;
                ldapContext = null;
                try {
                    ldapContext = TomEELDAPIdentityStore.lookup(this.definition.url(), this.definition.bindDn(), this.definition.bindDnPassword());
                    callerName = usernamePasswordCredential.getCaller();
                    callerDn = this.getCallerDn(ldapContext, callerName);
                    if (callerDn != null) break block6;
                    CredentialValidationResult credentialValidationResult = CredentialValidationResult.INVALID_RESULT;
                    this.silentlyCloseLdapContext(ldapContext);
                    return credentialValidationResult;
                }
                catch (Throwable throwable) {
                    this.silentlyCloseLdapContext(ldapContext);
                    throw throwable;
                }
            }
            if (this.authenticateWithCallerDn(usernamePasswordCredential, callerDn)) break block7;
            CredentialValidationResult credentialValidationResult = CredentialValidationResult.INVALID_RESULT;
            this.silentlyCloseLdapContext(ldapContext);
            return credentialValidationResult;
        }
        Set<String> groups = null;
        if (this.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
            groups = this.getGroupsWithCallerDn(ldapContext, callerDn);
        }
        CredentialValidationResult credentialValidationResult = new CredentialValidationResult(null, callerName, callerDn, null, groups);
        this.silentlyCloseLdapContext(ldapContext);
        return credentialValidationResult;
    }

    private Set<String> getGroupsWithCallerDn(LdapContext ldapContext, String callerDn) {
        if (StringUtils.isEmpty((CharSequence)callerDn)) {
            return Collections.emptySet();
        }
        if (StringUtils.isEmpty((CharSequence)this.definition.groupSearchBase()) && StringUtils.isNotEmpty((CharSequence)this.definition.groupMemberOfAttribute())) {
            HashSet<String> groups = null;
            try {
                Attributes attributes = ldapContext.getAttributes(callerDn, new String[]{this.definition.groupMemberOfAttribute()});
                Attribute memberOfAttribute = attributes.get(this.definition.groupMemberOfAttribute());
                groups = new HashSet<String>();
                if (memberOfAttribute != null) {
                    for (Object group : Collections.list(memberOfAttribute.getAll())) {
                        if (group == null) continue;
                        LdapName dn = new LdapName(group.toString());
                        Attribute attribute = dn.getRdn(dn.size() - 1).toAttributes().get(this.definition.groupNameAttribute());
                        if (attribute == null) {
                            throw new RuntimeException(this.definition.groupNameAttribute() + "does not match any group in DN: " + group.toString());
                        }
                        String groupName = attribute.get(0).toString();
                        if (groupName == null) continue;
                        groups.add(groupName);
                    }
                }
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            return groups;
        }
        String filter = null;
        filter = StringUtils.isNotEmpty((CharSequence)this.definition.groupSearchFilter()) ? String.format(this.definition.groupSearchFilter(), callerDn) : String.format(DEFAULT_GROUP_FILTER, this.definition.groupMemberAttribute(), callerDn);
        List<SearchResult> searchResults = TomEELDAPIdentityStore.query(ldapContext, this.definition.groupSearchBase(), filter, this.getGroupSearchControls());
        HashSet<String> groups = new HashSet<String>();
        try {
            for (SearchResult searchResult : searchResults) {
                Attribute attribute = searchResult.getAttributes().get(this.definition.groupNameAttribute());
                if (attribute == null) continue;
                for (Object group : Collections.list(attribute.getAll())) {
                    if (group == null) continue;
                    groups.add(group.toString());
                }
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return groups;
    }

    private boolean authenticateWithCallerDn(UsernamePasswordCredential usernamePasswordCredential, String callerDn) {
        try {
            this.silentlyCloseLdapContext(TomEELDAPIdentityStore.lookup(this.definition.url(), callerDn, usernamePasswordCredential.getPasswordAsString()));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void silentlyCloseLdapContext(LdapContext callerDnContext) {
        if (callerDnContext == null) {
            return;
        }
        try {
            callerDnContext.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private String getCallerDn(LdapContext ldapContext, String callerName) {
        String callerDn = null;
        if (StringUtils.isNotEmpty((CharSequence)this.definition.callerBaseDn()) && StringUtils.isNotEmpty((CharSequence)this.definition.callerNameAttribute()) && StringUtils.isEmpty((CharSequence)this.definition.callerSearchBase())) {
            callerDn = String.format("%s=%s,%s", this.definition.callerNameAttribute(), callerName, this.definition.callerBaseDn());
        } else {
            String filter = null;
            filter = StringUtils.isNotEmpty((CharSequence)this.definition.callerSearchFilter()) ? String.format(this.definition.callerSearchFilter(), callerName) : String.format(DEFAULT_USER_FILTER, this.definition.callerNameAttribute(), callerName);
            List<SearchResult> callerDns = TomEELDAPIdentityStore.query(ldapContext, this.definition.callerSearchBase(), filter, this.getCallerSearchControls());
            if (callerDns.size() == 1) {
                callerDn = callerDns.get(0).getNameInNamespace();
            }
        }
        return callerDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new IdentityStorePermission("getGroups"));
        }
        LdapContext ldapContext = null;
        try {
            ldapContext = TomEELDAPIdentityStore.lookup(this.definition.url(), this.definition.bindDn(), this.definition.bindDnPassword());
            String callerDn = validationResult.getCallerDn();
            if (StringUtils.isEmpty((CharSequence)callerDn)) {
                callerDn = this.getCallerDn(ldapContext, validationResult.getCallerPrincipal().getName());
            }
            Set<String> set = this.getGroupsWithCallerDn(ldapContext, callerDn);
            this.silentlyCloseLdapContext(ldapContext);
            return set;
        }
        catch (Throwable throwable) {
            this.silentlyCloseLdapContext(ldapContext);
            throw throwable;
        }
    }

    public int priority() {
        return this.definition.priority();
    }

    public Set<IdentityStore.ValidationType> validationTypes() {
        return this.validationTypes;
    }

    public static LdapContext lookup(String url, String bindDn, String bindDnPassword) {
        Hashtable<String, String> ldapEnvironment = new Hashtable<String, String>();
        ldapEnvironment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapEnvironment.put("java.naming.provider.url", url);
        ldapEnvironment.put("java.naming.security.authentication", "simple");
        ldapEnvironment.put("java.naming.security.principal", bindDn);
        ldapEnvironment.put("java.naming.security.credentials", bindDnPassword);
        try {
            return new InitialLdapContext(ldapEnvironment, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SearchControls getCallerSearchControls() {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(TomEELDAPIdentityStore.of(this.definition.callerSearchScope()));
        controls.setCountLimit(this.definition.maxResults());
        controls.setTimeLimit(this.definition.readTimeout());
        return controls;
    }

    private SearchControls getGroupSearchControls() {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(TomEELDAPIdentityStore.of(this.definition.groupSearchScope()));
        controls.setCountLimit(this.definition.maxResults());
        controls.setTimeLimit(this.definition.readTimeout());
        controls.setReturningAttributes(new String[]{this.definition.groupNameAttribute()});
        return controls;
    }

    private static int of(LdapIdentityStoreDefinition.LdapSearchScope searchScope) {
        if (searchScope == LdapIdentityStoreDefinition.LdapSearchScope.ONE_LEVEL) {
            return 1;
        }
        if (searchScope == LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE) {
            return 2;
        }
        return 1;
    }

    private static List<SearchResult> query(LdapContext ldapContext, String base, String filter, SearchControls controls) {
        try {
            return Collections.list(ldapContext.search(base, filter, controls));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

