/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.credential.BasicAuthenticationCredential;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ApplicationScoped
public class BasicAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    private IdentityStoreHandler identityStoreHandler;
    @Inject
    private Supplier<BasicAuthenticationMechanismDefinition> basicAuthenticationMechanismDefinition;

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        try {
            BasicAuthenticationCredential credential = this.parseAuthenticationHeader(request.getHeader("Authorization"));
            CredentialValidationResult result = this.identityStoreHandler.validate((Credential)credential);
            if (result.getStatus().equals((Object)CredentialValidationResult.Status.VALID)) {
                return httpMessageContext.notifyContainerAboutLogin(result);
            }
        }
        catch (IllegalArgumentException | IllegalStateException credential) {
            // empty catch block
        }
        if (httpMessageContext.isProtected()) {
            String realmName = this.basicAuthenticationMechanismDefinition.get().realmName();
            if (realmName.isEmpty()) {
                response.setHeader("WWW-Authenticate", "Basic");
            } else {
                response.setHeader("WWW-Authenticate", String.format("Basic realm=\"%s\"", realmName));
            }
            return httpMessageContext.responseUnauthorized();
        }
        return httpMessageContext.doNothing();
    }

    private BasicAuthenticationCredential parseAuthenticationHeader(String authenticationHeader) {
        return Optional.ofNullable(authenticationHeader).filter(header -> !header.isEmpty()).filter(header -> header.startsWith("Basic ")).map(header -> header.substring(6)).map(BasicAuthenticationCredential::new).orElseGet(() -> new BasicAuthenticationCredential(""));
    }
}

