/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Map;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.enterprise.context.Dependent;
import javax.security.enterprise.identitystore.Pbkdf2PasswordHash;

@Dependent
public class TomEEPbkdf2PasswordHash
implements Pbkdf2PasswordHash {
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int SALT_BYTE_SIZE = 24;
    public static final int HASH_BYTE_SIZE = 18;
    public static final int PBKDF2_ITERATIONS = 64000;
    private SecureRandom random = new SecureRandom();
    private String configuredAlgorithm = "PBKDF2WithHmacSHA1";
    private int configuredIterations = 64000;
    private int configuredSaltSize = 24;
    private int configuredHashSize = 18;

    public void initialize(Map<String, String> parameters) {
        String keySizeParameter;
        String saltSizeParameter;
        String iterationsParameter;
        String algorithmParameter = parameters.get("Pbkdf2PasswordHash.Algorithm");
        if (algorithmParameter != null) {
            this.configuredAlgorithm = algorithmParameter;
        }
        if ((iterationsParameter = parameters.get("Pbkdf2PasswordHash.Iterations")) != null) {
            this.configuredIterations = Integer.parseInt(iterationsParameter);
        }
        if ((saltSizeParameter = parameters.get("Pbkdf2PasswordHash.SaltSizeBytes")) != null) {
            this.configuredSaltSize = Integer.parseInt(saltSizeParameter);
        }
        if ((keySizeParameter = parameters.get("Pbkdf2PasswordHash.KeySizeBytes")) != null) {
            this.configuredHashSize = Integer.parseInt(keySizeParameter);
        }
    }

    public String generate(char[] password) {
        byte[] salt = new byte[this.configuredSaltSize];
        this.random.nextBytes(salt);
        byte[] hash = this.pbkdf2(password, salt, this.configuredIterations, this.configuredHashSize, this.configuredAlgorithm);
        return TomEEPbkdf2PasswordHash.toString(this.configuredAlgorithm, this.configuredIterations, salt, hash);
    }

    public boolean verify(char[] password, String hashedPassword) {
        String[] params = hashedPassword.split(":");
        if (params.length != 4) {
            throw new RuntimeException("Missing fields in hashed password.");
        }
        String algorithm = params[0];
        int iterations = 0;
        try {
            iterations = Integer.parseInt(params[1]);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("Could not parse the iteration as an integer.", ex);
        }
        if (iterations < 1) {
            throw new RuntimeException("Invalid number of iterations. Must be >= 1.");
        }
        byte[] salt = null;
        try {
            salt = TomEEPbkdf2PasswordHash.fromBase64(params[2]);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Base64 decoding of salt failed.", ex);
        }
        byte[] expectedHash = null;
        try {
            expectedHash = TomEEPbkdf2PasswordHash.fromBase64(params[3]);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Base64 decoding of pbkdf2 output failed.", ex);
        }
        byte[] actual = this.pbkdf2(password, salt, iterations, expectedHash.length, algorithm);
        return TomEEPbkdf2PasswordHash.slowEquals(expectedHash, actual);
    }

    private byte[] pbkdf2(char[] password, byte[] salt, int iterations, int length, String algorithm) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, length * 8);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
            return skf.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Hash algorithm not supported.", ex);
        }
        catch (InvalidKeySpecException ex) {
            throw new RuntimeException("Invalid key spec.", ex);
        }
    }

    private static String toString(String algorithm, int iterations, byte[] salt, byte[] hash) {
        return algorithm + ":" + iterations + ":" + TomEEPbkdf2PasswordHash.toBase64(salt) + ":" + TomEEPbkdf2PasswordHash.toBase64(hash);
    }

    private static byte[] fromBase64(String hex) throws IllegalArgumentException {
        return Base64.getDecoder().decode(hex);
    }

    private static String toBase64(byte[] array) {
        return Base64.getEncoder().encodeToString(array);
    }

    private static boolean slowEquals(byte[] expected, byte[] actual) {
        int diff = expected.length ^ actual.length;
        for (int i = 0; i < expected.length && i < actual.length; ++i) {
            diff |= expected[i] ^ actual[i];
        }
        return diff == 0;
    }
}

