/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import java.util.Date;
import javax.mail.search.ComparisonTerm;

public abstract class DateTerm
extends ComparisonTerm {
    private static final long serialVersionUID = 4818873430063720043L;
    protected Date date;

    protected DateTerm(int comparison, Date date) {
        this.comparison = comparison;
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public int getComparison() {
        return this.comparison;
    }

    protected boolean match(Date match) {
        long matchTime = match.getTime();
        long mytime = this.date.getTime();
        switch (this.comparison) {
            case 3: {
                return matchTime == mytime;
            }
            case 4: {
                return matchTime != mytime;
            }
            case 1: {
                return matchTime <= mytime;
            }
            case 2: {
                return matchTime < mytime;
            }
            case 5: {
                return matchTime > mytime;
            }
            case 6: {
                return matchTime >= mytime;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DateTerm)) {
            return false;
        }
        DateTerm term = (DateTerm)other;
        return this.comparison == term.comparison && this.date.equals(term.date);
    }

    @Override
    public int hashCode() {
        return this.date.hashCode() + super.hashCode();
    }
}

