/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;

public class StubBuilder {
    public static Collection generateStubs(File dir, Collection interfaces) throws IOException {
        HashSet pending = new HashSet();
        ArrayList<String> result = new ArrayList<String>();
        TypeRepository rep = new TypeRepository(null);
        for (Class cl : interfaces) {
            RemoteDescriptor desc = (RemoteDescriptor)rep.getDescriptor(cl);
            desc.addDependencies(pending);
        }
        Class[] classes = new Class[pending.size()];
        pending.toArray(classes);
        for (int i = 0; i < classes.length; ++i) {
            if (!Remote.class.isAssignableFrom(classes[i])) continue;
            RemoteDescriptor desc = (RemoteDescriptor)rep.getDescriptor(classes[i]);
            String name = desc.getStubClassName();
            String file = name.replace('.', File.separatorChar) + ".java";
            File stubfile = new File(dir, file);
            File gendir = stubfile.getParentFile();
            gendir.mkdirs();
            PrintWriter pw = new PrintWriter(new FileWriter(stubfile));
            desc.writeStubClass(pw);
            pw.close();
            result.add(file);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        ArrayList al = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            al.add(Class.forName(args[i]));
        }
        StubBuilder.generateStubs(new File("."), al);
    }
}

